#define MBED_PLATFORM

#include <jsonlite.h>
#include "M2XStreamClient.h"

#include "mbed.h"
#include "EthernetInterface.h"

char deviceId[] = "8f4eeb39f1cb1dc95699bfa266e57662"; // Device you want to push to
char streamName[] = "temp_data"; // Stream you want to push to
char m2xKey[] = "4c3ba5e22fc074d4358888afbe96efa7"; // Your M2X API Key or Master API Key

// For Static IP
static const char* mbedIp       = "192.168.0.85";  //IP
static const char* mbedMask     = "255.255.255.0";  // Mask
static const char* mbedGateway  = "192.168.0.254";  //Gateway

Client client;
M2XStreamClient m2xClient(&client, m2xKey);

EthernetInterface eth;


int main() {
  float data = 32.5;
   
  eth.init(mbedIp,mbedMask,mbedGateway);
  eth.connect();
  printf("IP Address: %s\n", eth.getIPAddress());

  while (true) {
    double val = data;
    printf("Current temperature is: %lf", val);

    int response = m2xClient.updateStreamValue(deviceId, streamName, val);
    printf("Response code: %d\n", response);

    if (response == -1) while (true) ;

    delay(5000);
  }
}