#include "mbed.h"
#include "EthernetInterface.h"
#include "HTTPClient.h"

EthernetInterface eth;
HTTPClient http;
Serial pc(P0_2, P0_3);
char str[512];

// For Static IP
static const char* mbedIp       = "192.168.0.160";  //IP
static const char* mbedMask     = "255.255.255.0";  // Mask
static const char* mbedGateway  = "192.168.0.254";  //Gateway

int main() 
{
//    eth.init(); //Use DHCP
    
    int s = eth.init(mbedIp,mbedMask,mbedGateway); //Use these parameters for static IP
    
    if( s != NULL )
    {
        pc.printf( "Could not initialise. Will halt!\n\r" );        
        exit( 0 );
    }    
        
    s = eth.connect();
    
    if( s != NULL )
    {
        pc.printf( "Could not connect. Will halt!\n\r" );
        exit( 0 );
    }
    else 
    {
        pc.printf( "IP: %s\n\r", eth.getIPAddress() );    
    }
}