#include "mbed.h"                   // Basic Library required for onchip peripherals
#include "EthernetInterface.h"      // Ethernet Library 
#include "NTPClient.h"              // Network Time Protocol client Library
//#include "C12832_lcd.h"             // Library for SPI based LCD

/* Create Objects */  

EthernetInterface eth;  // Initialize Ethernet object
NTPClient ntp;          // Initialize NTP object
Serial pc(PC_6,PC_7);
//Serial pc(USBTX,USBRX);
// For Static IP
static const char* mbedIp       = "192.168.1.160";  //IP
static const char* mbedMask     = "255.255.255.0";  // Mask
static const char* mbedGateway  = "192.168.1.1";  //Gateway

int main()
{
    EthernetInterface eth;
     int s = eth.init(); // For DHCP uncomment this line
//    int s = eth.init(mbedIp,mbedMask,mbedGateway); //Use these parameters for static IP
    if( s != NULL )
    {
        pc.printf( "Could not initialise. Will halt!\n\r" );        
        exit( 0 );
    }    
    s = eth.connect();
    if( s != NULL )
    {
        pc.printf( "Could not connect. Will halt!\n\r" );
        exit( 0 );
    }
    else 
    {
        pc.printf( "IP: %s\n\r", eth.getIPAddress() );    
    }
    pc.printf("Connected! IP Address is %s\r\n", eth.getIPAddress());
    pc.printf("Trying to update time...\r\n");
    if (ntp.setTime("0.pool.ntp.org") == 0) { // ntp server
        pc.printf("Set time successfully\r\n");
        while(1) {
            
            time_t ctTime;
            ctTime = time(NULL);
            pc.printf("%s\r\n", ctime(&ctTime));
            pc.printf("Current Time (UTC)");
            wait(1);
        }
    } else {
        pc.printf("NTP Error\r\n");
    }

    eth.disconnect();

    while(1) {
    }
}
