#include "mbed.h"
#include "TextLCD.h"  // LCD LIBRARY

//***************
//BLUETOOTH HEADER
//By default the connection is set to 9600 bps
Serial bluetooth(PB_6, PB_3);//Pins used for Serial Comm
//***************


//***************
//LCD HEADER
DigitalOut myled(LED1);//* "myled" is the name of the variable  
                       //* "LED1" refers to the integrated LED on the NUCLEO board 
                       //   but you can declare any other pin you like
                       
TextLCD ark(PA_0,PA_1,PA_4,PB_0,PC_1,PC_0);// rs, e, d4-d7  -- REGISTER SELECT / ENABLE / DATA-PIN
//Enable A0
//RS     A1
//A      A2
//B      A3
//C      A4
//D      A5
//***************


//***************
//ENCABEZADO PWM
PwmOut led(PB_10);//Sends out the Enable signal for the L293D
DigitalOut pa8(PA_8);   //DC motor 1
DigitalOut pa9(PA_9);   //DC motor 1
DigitalOut pb4(PB_4);   //DC motor 2
DigitalOut pb5(PB_5);   //DC motor 2
//***************



int main()
{
int cont = 0;
 // lcd.cls(); To clear screen
    bluetooth.baud(9600);//Default is 9600 bps

    while(1) {
        char c = bluetooth.getc(); // Get daa sent from the bluetooth module
            if (c == 's') {// S = Backwards 
               
               ark.cls();
               ark.printf("Backwards");

                pa8.write(1);
                pa9.write(0);
                pb4.write(1);
                pb5.write(0);
                
                led.period(8.0f);      // 8 second period//8s
                led.write(0.25f);      // 25% duty cycle, relative to period
             }
            
             if (c == 'w') {// 'W' = Forward
             ark.cls();
             ark.printf("Forward");
             
                pa8.write(0);
                pa9.write(1);
                pb4.write(0);
                pb5.write(1);
                
                led.period(8.0f);      // 8 second period
                led.write(0.25f);      // 25% duty cycle, relative to period
              }

              if (c == 'a') {// 'A' = Left Turn
              ark.cls();
              ark.printf("Left Turn");

                pa8.write(0);
                pa9.write(1);
                pb4.write(0);
                pb5.write(0);
                
                led.period(8.0f);      // 8 second period
                led.write(0.25f);      // 25% duty cycle, relative to period
                }
        
              if (c == 'd') {// 'D' = Right Turn
              ark.cls();
              ark.printf("Right Turn");

                pa8.write(0);
                pa9.write(0);
                pb4.write(0);
                pb5.write(1);
                
                led.period(8.0f);      // 8 second period
                led.write(0.25f);      // 25% duty cycle, relative to period
                }
    }
}
