/*
 * 640x480 60Hz fullgraphic monochrome VGA Driver demo program
 *
 * Copyright (C) 2011 by Ivo van Poorten <ivop(at)euronet.nl>
 * and Gert van der Knokke <gertk(at)xs4all.nl>
 * This file is licensed under the terms of the GNU Lesser
 * General Public License, version 3.
 *
 * Inspired by Simon's (not Ford) Cookbook entry and Cliff Biffle's
 * assembly code.
 */
 
#include "mbed.h"
#include "vga640x480g.h" // vga p5, p8, p25

//Serial display(p9,p10);

DigitalOut resety(p17/*, 1*/);
DigitalOut clocky(p18/*, 1*/);
DigitalIn rw(p19);
DigitalOut addressDisable(p20/*, 1*/);
BusInOut mixBus(p21, p22, p23, p24, p16, p26, p27, p28); 
BusIn addrHigh(p29, p30);

BusOut addrLeds(LED1, LED2, LED3, LED4);
Serial pc(USBTX, USBRX); // tx, rx

LocalFileSystem local("local");               // Create the local filesystem under the name "local"

char memory[4*256];

void halfcycle() {
    wait_ms(1);
}

void busDisplay(int addr, int data, int flags) {
    char tmp[255];
    sprintf(tmp, "%04X %04X", addr, data);
    vga_putstring(400,370,tmp,WHITE);
//    display.putc(0x76);
//    display.putc((addr & 0x00f0) >> 4);
//    display.putc(addr & 0x000f);
//    display.putc((data & 0xf0) >> 4);
//    display.putc(data & 0x0f);
//    display.putc(0x77);
//    display.putc(((addr & 0x0300) >> 8) | (flags << 2));
//    pc.printf("%X %X %X\r\n", addr, data, flags);
}

// visual feedback
//DigitalOut myled(LED1);

// define serial port for debug
//Serial linktopc(USBTX,USBRX);

void draw() {
    // init the VGA subsystem (always do this first!)
    //init_vga();

    int s,t;

    // serial port on at 115200 baud
    //linktopc.baud(115200);
    //setbuf(stdout, NULL); // no buffering for this filehandle
    
    // clear the screen
    vga_cls();
    
    // draw some circles
    //for (t=10; t<200; t+=5)
    //vga_circle(20+t,399-t,t,WHITE);

    // draw some boxes
    //for (t=10; t<100; t+=5)
    //vga_box(400+t,100+t,400+t*2,100+t*2,WHITE);
  
    // circumfence the screen
    vga_box(0,0,639,479,WHITE);
    
    // show the complete character set
    for (s=0; s<4; s++) {
        for (t=0; t<64; t++) {
            vga_putchar(20+t*8,20+16*s,t+s*64,WHITE);
        }
    }

    // put a string on screen
    //vga_putstring(400,370,"Hello World!",WHITE);

    // draw some lines
    //vga_line(400,390,500,390,WHITE);
    //vga_line(500,475,600,375,WHITE);

    // draw a filled box
    vga_filledbox(450,330,550,360,1);

    // draw some more boxes
    //for (t=10; t<320; t+=5)
    //vga_box(100+t,440-t/16,110+t,440+t/16,WHITE);
    return;
}

int main() {
    resety = 1; clocky = 1; addressDisable = 1;  
    int addr, haddr, _rw;
    init_vga();
    resety = 0;
    int count = 0;
    // serial port on at 115200 baud
    //pc.baud(115200);
    //setbuf(stdout, NULL); // no buffering for this filehandle
    draw();
//    display.baud(9600);
//    display.putc(0x76);
//    display.putc('h');display.putc('E');display.putc('L');display.putc('o');
////    pc.printf("Hello World!\r\n");
   // wait(1.0);
    FILE *fp = fopen("/local/6502.OUT", "r");
    for (int i=0; i<256; i++) {
        int c = fgetc(fp);
        addr = 2*256 + i;
        if (c >= 0) {
            memory[addr] = c & 0xff;
        } else {
            break;
        }
        busDisplay(addr, memory[addr], 0);
        //wait_ms(125);
    }
    // reset vector   
    memory[3*256 + 0xfc] = 0;
    memory[3*256 + 0xfd] = 0x80;
    fclose(fp);
//    display.putc(0x76);
//    display.putc('G');display.putc('o');
//    wait(1.0);
//    
////    pc.printf("run...\r\n");
    while(1) {
        if (count++ == 10) {
            resety = 1;
        }
        //XXX use timer
        clocky = 0;
        mixBus.input();
        addressDisable = 0;
        halfcycle();
        addr = mixBus.read();
        haddr = addrHigh.read();  
        addr = addr + (haddr * 256);
        clocky = 1;
        addressDisable = 1;
        _rw = rw;
        if (_rw) {
            mixBus.output();
            mixBus.write(memory[addr]);
            halfcycle();
        } else {
            halfcycle();
            memory[addr] = mixBus.read();
        }
        busDisplay(addr, memory[addr], _rw); //wait_ms(125);
    }
}
