#include "a4988.h"
#include "mbed.h"
Stepper::Stepper(PinName _en, PinName _stepPin, PinName _direction):
    en(_en),
    stepPin(_stepPin),
    direction(_direction)
{
    
}
 
void Stepper::step(int dir, int frequency ,volatile int _remain)
{
    //fun = &Stepper::step_control;
    if (dir == 1) {
        direction = 0;
    } else if (dir == 0) {
        direction = 1;
    }
    remain = _remain;
    step_ticker.attach(this, &Stepper::step_control,1.0/frequency);
}
 
void Stepper::enable()
{
    en = 0;
}
 
void Stepper::disable()
{
    en = 1;
}

void Stepper::step_control()
{
        if(remain == 0)
        {         
            return;
        }else if(stepPin){
            stepPin = 0; //STEP 1->0
            remain--;
        }else{
            stepPin = 1; //STEP 0->1
        }
}
