#ifndef __SENSORS_H
#define __SENSORS_H

#ifdef ENABLE_SENSORS

#include "mbed.h"
#include "esp8266.h"



//==========================================
class sr501
{
/*****
 * 红外热释电对象
 * 感应输出高电平
*****/
  private:
//    DigitalIn signal;
    bool status;
    InterruptIn signal;
    void triggered();
  public:
    sr501(PinName pSignal);
    bool operator==(const bool &target);
    void reset();
    int read();
    
#ifdef ENABLE_ESP8266
    void send_status(Esp8266 & client, const char * topic);
#endif  // ENABLE_ESP8266

};
//=========================================
//+++++++++++++++++++++BH1750+++++++++++++++++++++++++++++
#define BH1750_I2CADDR 0x46
#define BH1750_POWER_DOWN 0x00                  // No active state
#define BH1750_POWER_ON 0x01                    // Wating for measurment command
#define BH1750_RESET 0x07                       // Reset data register value - not accepted in POWER_DOWN mode
#define BH1750_CONTINUOUS_HIGH_RES_MODE  0x10   // Start measurement at 1lx resolution. Measurement time is approx 120ms.
#define BH1750_CONTINUOUS_HIGH_RES_MODE_2  0x11 // Start measurement at 0.5lx resolution. Measurement time is approx 120ms.
#define BH1750_CONTINUOUS_LOW_RES_MODE  0x13    // Start measurement at 4lx resolution. Measurement time is approx 16ms.

// Start measurement at 1lx resolution. Measurement time is approx 120ms.
// Device is automatically set to Power Down after measurement.
#define BH1750_ONE_TIME_HIGH_RES_MODE  0x20

// Start measurement at 0.5lx resolution. Measurement time is approx 120ms.
// Device is automatically set to Power Down after measurement.
#define BH1750_ONE_TIME_HIGH_RES_MODE_2  0x21

// Start measurement at 1lx resolution. Measurement time is approx 120ms.
// Device is automatically set to Power Down after measurement.
#define BH1750_ONE_TIME_LOW_RES_MODE  0x23
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++
class BH1750
{
    
/*****
*
*****/
  private:
    I2C link;
    char rawdata[2];
    bool status;
  public:
    BH1750(PinName sda,PinName scl);
    BH1750(PinName sda,PinName scl,char mode[]);
    float getlightdata();
    
#ifdef ENABLE_ESP8266
    void send_data(Esp8266 & client, const char * topic);
#endif  // ENABLE_ESP8266

};
//===========================================
class mq
{
/*****
*
*****/
  private:
    bool status;
    InterruptIn signal;
    AnalogIn signallevel;
    
    void triggered();                                     
  public:
    mq(PinName dio);
    mq(PinName dio,PinName aio);
    bool operator==(const bool &target);
    float getairdata(); 
    void reset();
    int read();
    
#ifdef ENABLE_ESP8266
    void send_data(Esp8266 & client, const char * topic);
#endif  // ENABLE_ESP8266

};

//===========================================
class dht11
{
/*****
*
*****/
  private:
    Timer timer;
    Timer starttime;
    DigitalInOut datapin;
    float H;
    float T;                                   
  public:
    dht11(PinName pin);
    int getdata();  
    float gethumidity();
    float gettemperature();
    
#ifdef ENABLE_ESP8266
    void send_temp(Esp8266 & client, const char * topic);
    void send_humi(Esp8266 & client, const char * topic);
#endif  // ENABLE_ESP8266

};
//==========================================DS18B20
class DS18B20
{
/*****
*
*****/
  private:
    DigitalInOut datapin;
    uint8_t dat;
    float T;

    int start();
    void writebyte(uint8_t send);
    uint8_t readByte();
    float transfer(uint8_t h,uint8_t l);                                 
  public:
    DS18B20(PinName pin);
    int getdata();  
    float gettemperature();
    
#ifdef ENABLE_ESP8266
    void send_temp(Esp8266 & client, const char * topic);
#endif  // ENABLE_ESP8266

};
//==========================================YL-38通用传感
class YL
{
/*****
*
*****/
  private:
    bool status;
    InterruptIn signal;
    AnalogIn signallevel;
    
    void triggered();                                     
  public:
    YL(PinName dio);
    YL(PinName dio,PinName aio);
    bool operator==(const bool &target);
    float getairdata(); 
    void reset();
    int read();
    
#ifdef ENABLE_ESP8266
    void send_data(Esp8266 & client, const char * topic);
#endif  // ENABLE_ESP8266
};
//========================================
#define BMP180_ADDRESS          0x77<<1 // I2C address of BMP180, eight bit address on mbed
#define BMP180_WHO_AM_I         0xD0    // WHO_AM_I id of BMP180, should return 0x55
#define BMP180_RESET            0xE0
#define BMP180_CONTROL          0xF4
#define BMP180_OUT_MSB          0xF6
#define BMP180_OUT_LSB          0xF7
#define BMP180_OUT_XLSB         0xF8

// Set initial input parameters

enum OSS {  // BMP-085 sampling rate
  OSS_0 = 0,  // 4.5 ms conversion time
  OSS_1=1,      // 7.5
  OSS_2=2,      // 13.5
  OSS_3=3       // 25.5
};



class BMP180 {
/*****
*
*****/
private:
    uint8_t OSS;           // maximum pressure resolution

    //Set up I2C, (SDA,SCL)
    I2C i2c;
    
    // These are constants used to calculate the temperature and pressure from the BMP-180 sensor
    int16_t ac1, ac2, ac3, b1, b2, mb, mc, md, b5;  
    uint16_t ac4, ac5, ac6;   

    void writeByte(uint8_t address, uint8_t subAddress, uint8_t data);
    char readByte(uint8_t address, uint8_t subAddress);
    void readBytes(uint8_t address, uint8_t subAddress, uint8_t count, uint8_t * dest);
    
    // Stores all of the BMP180's calibration values into global variables
    // Calibration values are required to calculate temp and pressure
    // This function should be called at the beginning of the program
    // These BMP-180 functions were adapted from Jim Lindblom of SparkFun Electronics
    void BMP180Calibration();
public:
    BMP180(PinName sda,PinName scl) ;
    // Temperature returned will be in units of 0.1 deg C
    long BMP180GetTemperature();

    // Calculate pressure read calibration values  
    // b5 is also required so BMP180GetTemperature() must be called first.
    // Value returned will be pressure in units of Pa.
    long BMP180GetPressure();

#ifdef ENABLE_ESP8266
    void send_press(Esp8266 & client, const char * topic);
    void send_temp(Esp8266 & client, const char * topic);
#endif  // ENABLE_ESP8266
};
//================================================
class GP2Y1010
{
/*****
*
*****/
  private:
    AnalogIn measurePin ;            
    DigitalOut ledPower; 
    unsigned int samplingTime ;
    unsigned int deltaTime ;
    unsigned int sleepTime ;
 
    float voMeasured ;
    float calcVoltage ;
    float dustDensity ;
                                      
  public:
    GP2Y1010(PinName ledPower,PinName measurePin);
    float getairdata(); 
};
//=============================================

#endif  // ENABLE_SENSORS

#endif  // !__SENSORS_H
