#include "sensors.h"
#include "mbed.h"
#include "esp8266.h"
#include "useful_func.h"

Serial ser2usb(PA_9, PA_10, 9600);  
DigitalOut myled(PC_13);

//�����豸���ƣ����ڶ��ĺͷ�����Ϣ                                             /********************************/
const char device[] = "living_room";                                            /*      �����޸Ľڵ�����       */
                                                                                /*------------------------------*/
//�������д�����, ÿ��һ��, ÿ�������ֵ�λ���������, ��λһ�㲻д
// ������������Ĵ��������ƻ�������������, ����: lightIntencity
const char* sensors[][2] = {                                                    /*------------------------------*/
    "sr501", "",                                                                /*      �������Ӵ�����           */
    "report", "",                                                               /*------------------------------*/
    NULL, NULL //last line must end with empty pointer
};

//��������ִ����, ÿ��һ��, ÿ�������ֲ����������������
// ����������ִ��������, ����: fan
const char* actuators[][2] = {                                                  /*------------------------------*/
    "command", "",                                                              /*      ��������ִ����           */
    "dat", "",                                                                  /********************************/
    "light", "", 
    NULL, NULL //last line must end with empty pointer
};

int main()
{
    // ����������
    sr501 x(PA_0);
    
    // ����ִ����
    DigitalOut light(PA_13);
    
    /*----- ��ʼ���׶� -----*/
    // connect to wifi
    ser2usb.printf("Initializing...\r\n");
    Esp8266 client(PB_10, PB_11, "iot_b827eb8fb527", "7c02b50b");// TX pin / RX pin / SSID / Password

    // connect to server
    ser2usb.printf("connecting to mqtt server...\r\n");
    mqtt_client_init(client, device, sensors, actuators);
    
    // done report
    ser2usb.printf("--Initialization done.--\r\n");
    
    
    /*----- �������� -----*/
    // declare buff
    char actuator_name[32], control_value[32];

    
    bool sr501_status = false;
    
    
    /*----- ������ѭ�� -----*/
    while (1)
    {
        // looking for new command
        if (client.get_control_cmd(actuator_name, control_value))
        {
            ser2usb.printf("Received %s %s\r\n", actuator_name, control_value);
            if (strcmp(actuator_name, "command") == 0)          // �յ�command�µ�ָ��
            {
                ser2usb.printf("received_a_command\r\n");
                client.publish_value("report", "received_a_command");
            }
            else if (strcmp(actuator_name, "dat") == 0)         // �յ�dat�µ�ָ��
            {
                ser2usb.printf("received_a_data\r\n");
                client.publish_value("report", "received_a_data");
            }
            else if (strcmp(actuator_name, "light") == 0)       // �յ�light�µ�ָ��
            {
                ser2usb.printf("light control\r\n");
                client.publish_value("report", "light_control");
                if (strcmp(control_value, "on") == 0)               // �����on
                {                                   // ����
                    light = 1;
                    ser2usb.printf("On. \r\n");
                }
                else if (strcmp(control_value, "off") == 0)         // �����off
                {                                   // �ص�
                    light = 0;
                    ser2usb.printf("Off. \r\n");
                }
            }
            else
            {
                ser2usb.printf("unknow actuator\r\n");
                client.publish_value("report", "unknow_actuator");
            }
            
            if (x == sr501_status)
            {
                ;
            }
            else
            {
                sr501_status = x.read();
                char sensor_buff[32];                                   /*++++++++++++++++++++++++++++++++++++++++++*/
                sprintf(sensor_buff, "%d", sr501_status);               /*      �ϴ����ݷ���                      */
                client.publish_value(sensors[0][0], "_upload");         /*      �������report�·���_upload��Ϣ        */
                wait(0.01);                                             /*      ��һ��ʱ����ϴ�����������          */
                client.publish_value(sensors[0][0], sensor_buff);       /*      �ϴ����������ݺ��һ��ʱ��           */
                wait(0.01);                                             /*      Ȼ�������report�·���_end��Ϣ      */
                client.publish_value(sensors[0][0], "_end");            /*++++++++++++++++++++++++++++++++++++++++++*/
            }
        }
    }
}
