#include "esp8266.h"

#include <cstdarg>
#include <cstring>
#include "mbed.h"

// 连接模式
// 修改为需要连接的 wifi 的 ssid
const char wifi_ssid[] = "iotcar";
// 修改为需要连接 wifi 的密码
const char wifi_passwd[] = "iotcariotcar";

// 选定与 esp8266 相连接的串口
// 参数分别为 TX pin / RX pin
Serial ser2esp8266(PC_10, PC_11);

//#define DEBUG

int ser_baud = 9600;

//定义了一个调试的宏,C语言语法
#define ESP_CMD(format, ...) do{\
    ser2esp8266.printf("\r"); \
    ser2esp8266.printf(format "\r", ##__VA_ARGS__);\
    wait(0.3);\
}while(0)


#ifdef DEBUG
void cb1() {                                                                    //将USB串口上得到的消息通过WIFI模块发出去
    //ser2esp8266.putc(ser2usb.getc());
}
#endif

void simple_callback() {                                                        //将WIFI模块得到的消息通过USB串口打印到电脑上
    //ser2usb.putc(ser2esp8266.getc());
}
//#endif

// 热点模式
// 修改为需要建立的热点 ssid
const char adhoc_ssid[] = "iotcar";

// 此校园网登录账号无需修改
const char net_id[] = "yangc12";
const char net_passwd[] = "58a702fbc91f3e601de5188c6fb274ef";


// 接收 esp8266 侧数据的回调函数, 每次仅接收一个8位字符
static char esp_token[1024], esp_param[2048];
static char esp_tokenBuf[1024], esp_paramBuf[2048];   // recv from esp8266
static bool esp_buf_ready = false;
// 数据格式约定: #token+data
static void esp8266_rxCallback() {
    char in = ser2esp8266.getc();
    enum{STATE_WAIT, STATE_TOKEN, STATE_PARAM};
    static uint8_t state = STATE_WAIT;
    static int tokenLen, paramLen;
    switch(state){
    case STATE_WAIT:
        if(in == '#'){
            tokenLen = 0;
            state = STATE_TOKEN;
            //ser2usb.putc('w');
        }
        break;
    case STATE_TOKEN:
        //ser2usb.putc('t');
        if(in == '+' || in == '\r' || in == '\n'){
            esp_tokenBuf[tokenLen] = '\0';
            if(in == '+'){
                paramLen = 0;
                state = STATE_PARAM;
                //ser2usb.putc('!');
            }else{
                //gotResponse(tokenBuf, NULL);
                //memcpy(esp_token, esp_tokenBuf, tokenLen);
                //esp_token[tokenLen] = '\0';
                esp_buf_ready = true;
                state = STATE_WAIT;
            }
        }else if(tokenLen+1 < sizeof(esp_tokenBuf)){
            esp_tokenBuf[tokenLen++] = in;
        }
        break;
    case STATE_PARAM:
        //ser2usb.putc('p');
        if(in == '\r' || in == '\n'){
            esp_paramBuf[paramLen] = '\0';
            //gotResponse(tokenBuf, paramBuf);
            //memcpy(esp_token, esp_tokenBuf, tokenLen);
            //memcpy(esp_param, esp_paramBuf, paramLen);
            //esp_token[tokenLen] = '\0';
            //esp_param[paramLen] = '\0';
            //ser2usb.putc('?');
            esp_buf_ready = true;
            state = STATE_WAIT;
            return;
        }else if(paramLen+1 < sizeof(esp_paramBuf)){
            esp_paramBuf[paramLen++] = in;
        }
        break;
    }
}


Esp8266::Esp8266(int mode)                                                      //定义类的函数
    : network_start(false), mqtt_start(false) 
{
    // serial to esp8266 init
    ser2esp8266.baud(ser_baud);
#ifndef DEBUG
    //ser2esp8266.attach(esp8266_rxCallback, Serial::RxIrq);    
#endif
    if (mode == 0) {                                                            // client mode 
        this->reset();
        this->connect_wifi();
        this->weblogin();
    } else {
    
    }
}

bool Esp8266::reset() {                                                         //定义类的函数
    ESP_CMD("node.restart()");
    wait(2);                                                                    // 延迟2s
    return true;
}   

bool Esp8266::connect_wifi() {                                                  //定义类的函数
    ESP_CMD("wifi.setmode(wifi.STATION)");
    ESP_CMD("wifi.sta.config([[%s]],[[%s]])", wifi_ssid, wifi_passwd);
    wait(2);
    // set auto autoconnect
    ESP_CMD("wifi.sta.autoconnect(1)");
    ESP_CMD("print('\\035wifi+'..wifi.sta.status())");
    network_start = true;
    return true;
}

bool Esp8266::weblogin() {                                                      //定义类的函数
    // not implemented yet
    return true;
}

bool Esp8266::connect_mqtt_broker(char *ip) {                                   //定义类的函数
    ESP_CMD("m = mqtt.Client('i_' .. node.chipid(), 120)");
    ESP_CMD("m:connect(\"%s\")", ip);
    wait(1);
    // subscribe all the topic
    mqtt_start = true;
    return true;
}
    
bool Esp8266::publish(char *topic, char *data, int size) {                      //定义类的函数
    //if (mqtt_start) {
        ESP_CMD("m:publish(\"%s\",\"%s\",0,0)", topic, data);
    //}
    wait(0.1);
    return true;
}

bool Esp8266::subscribe_poll(char *topic, char *data, int size) {               //定义类的函数
    //if (mqtt_start) {
        ESP_CMD("m:subscribe(\"%s\", 0)", topic);
        wait(0.1);
    //}
    ESP_CMD("m:on(\"message\", function(conn, topic, data)");
    ESP_CMD("if topic == \"%s\" then", topic);
    ESP_CMD("print(\"\\035\"..topic..\"+\"..data)");
    ESP_CMD("end");
    ESP_CMD("end)");
     
    ser2esp8266.attach(simple_callback, Serial::RxIrq);    
    //ser2esp8266.attach(esp8266_rxCallback, Serial::RxIrq);    
    
    while (0) {
        while(!esp_buf_ready);
        esp_buf_ready = false; 
        
        //ser2usb.putc('x');
        if (strcmp(topic, esp_tokenBuf) == 0) {
    
            if (size == -1) {
                //uint8_t len = strlen(esp_param);
                //memcpy(data, esp_param, len);
                //data[len] = '\0';
            } else {
                //memcpy(data, esp_param, size);
                //data[size] = '\0';
            }
            break;
        }
    }

    ESP_CMD("m:unsubscribe(\"%s\")", topic);
    return true;
}