/*-----------------------------------------------------
 File Name : main.cpp
 Purpose : For tcs3200 sensor
 Creation Date : 24-06-2017
 Last Modified :
 Created By : Jeasine Ma [jeasinema[at]gmail[dot]com]
-----------------------------------------------------*/
#include <cstdio>
#include <cstring>
#include <cstdarg>

#include "mbed.h"
#include "color.h"

// DEBUG USB serial
Serial ser2usb(USBTX, USBRX);
int ser_baud = 9600;
#define LOG(format, ...) do{\                                                   //定义了一个调试的宏,C语言语法
    ser2usb.printf(format "\r\n", ##__VA_ARGS__);\
}while(0)

int main() {
    // S0,S1,S2,S3,OUT
    ColorSensor color(PA_0, PA_1, PA_4, PB_0, PC_1);                            //用5个GPIO管脚
    while(1) {
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        LOG("Color: R:%d G:%d B:%d", red, green, blue);
        wait(1);
    }
}