#include "mbed.h"
#include "TextLCD.h"
#include "SDFileSystem.h"

//LCD显示屏  rs,     e,    d4-d7,                    model
TextLCD lcd(PC_13, PC_14, PC_15, PA_0, PA_1, PA_4, TextLCD::LCD20x4); // rs, e, d4-d7, model  V4版本
    
//SD卡          mosi, miso, sclk, cs,    name     用SPI端口
SDFileSystem sd(PB_15, PB_14, PB_13, PB_12, "sd");                                 
Serial pc(PA_9, PA_10);                                                         //与电脑通讯的串口

int main() {
    DirHandle *dh = opendir("/sd/");    //读取SD卡中的文件列表
    if(!dh){
        pc.printf("opendir error\n");
        return 1;
    }
    dirent *entry;
    for(;;){
        entry = dh->readdir();
        if(!entry)
            break;
        pc.printf("%s\r\n", entry->d_name);
    }
    dh->closedir();
    
    // 写文件例子
    FILE *fp2 = fopen("/sd/write.txt", "w");
    if (fp2 == NULL)
    {
        pc.printf("open error2!!\r\n");
        return 1;
    }
    pc.printf("file opened for write\r\n");
    fprintf(fp2, "hello\r\n");
    fprintf(fp2, "%d", 23333);
    fclose(fp2);  //写完文件要记得关闭，不然可能没保存上
    
    // 读文件例子
    FILE *fp = fopen("/sd/test.txt", "r"); //打开文件，路径以“/sd/”开头

    if (fp == NULL) //打开失败，原因可能是文件不存在，或卡没有连接好
    {
        pc.printf("open error!!\r\n");
        return 1;
    }
    pc.printf("file opened for read\r\n");
    char buf[64];
    while (fgets(buf, sizeof(buf), fp) != NULL) //读入一行的C函数
    {    
        pc.printf("%s", buf);
    }
    fclose(fp);  //关闭文件，释放资源
    
    //pc.printf("card type is 0x%x\r\n" , sd.card_type());

    return 0;


    lcd.printf("Hello World!");
    wait_ms(1000); //等待1秒
    lcd.cls(); //清屏
    
    for(int i=0; i<10000; i+=4){
        lcd.locate(0,0); //分别控制起始的列和行，从0开始
        lcd.printf("%d", i);
        wait_ms(1000); //等待1秒
        
        lcd.locate(0,1);
        lcd.printf("%d", i+1);
        wait_ms(1000);
        
        lcd.locate(0,2);
        lcd.printf("%d", i+2);
        wait_ms(1000);
        
        lcd.locate(0,3);
        lcd.printf("%d", i+3);
        wait_ms(1000);
        
        lcd.cls(); //清屏
    }

    

}
