/*Attach to RX Interrupt使用RX中断
*/

#include "mbed.h"

typedef signed char s8;
s8 Direction,Speed,steer1,steer2,steer3,steer4;    //typedef int8_t s8:-128~127
//extern Serial bluetoothreceive;
typedef enum
{
    CheckS,CheckW,Checka,Checkb,Checkc,Checkd,Checke,Checkf,CheckSum, CheckOver
}STATE;   //定义枚举类型STATE


DigitalOut Led(PB_5);
Serial pc(USBTX, USBRX);
int counter = 0;
bool flag = false;

//Serial pc(SERIAL_TX, SERIAL_RX);    //与上面的语句等价
void callback() {      //串口中断接收函数
    s8 u1Rec; 
    static STATE State = CheckS;// 初始状态待检查
    static s8 PositionTemp[7]={0,0,0,0,0,0,0};// 装载数据值a(左右转)b(前后退)c d e f舵机转动角度sum(求和校验)
                
        u1Rec = pc.getc();              //getc()是mbed函数,读取一个byte数据
        switch(State)
        {
        case CheckS:
            if(u1Rec==(s8)'S'){
                State=CheckW;//准备跳转至数据读取
            }else
                State=CheckS;
                break;
        case CheckW:
            if(u1Rec==(s8)'W'){
                State=Checka;
            }else if(u1Rec==(s8)'S')
                  State=CheckW;
                else 
                  State=CheckS;
                  break;
        case Checka:
            PositionTemp[0]=u1Rec;
            State=Checkb;
            break;
        case Checkb:
            PositionTemp[1]=u1Rec;
            State=Checkc;
            break;
        case Checkc:
            PositionTemp[2]=u1Rec;
            State=Checkd;
            break;
        case Checkd:
            PositionTemp[3]=u1Rec;
            State=Checke;
            break;
        case Checke:
            PositionTemp[4]=u1Rec;
            State=Checkf;
            break;
        case Checkf:
            PositionTemp[5]=u1Rec;
            State=CheckSum;
            break;
        case CheckSum:
            PositionTemp[6]=u1Rec;
            State=CheckOver;
            break;
        case CheckOver:
            if(u1Rec==(s8)'E'){
                State=CheckS;//准备跳转至数据读取
            } else {
                State=CheckS;
                break;
            }
            if(PositionTemp[6]==(s8)(PositionTemp[0]+PositionTemp[1]+PositionTemp[2]+PositionTemp[3]+PositionTemp[4]+PositionTemp[5]))
              {
                    Direction = PositionTemp[0];
                    Speed     = PositionTemp[1];
                    steer1    = PositionTemp[2];
                    steer2    = PositionTemp[3];
                    steer3    = PositionTemp[4];
                    steer4    = PositionTemp[5];
                    pc.printf("over\n");
                    pc.printf("Speed: %d \n", Speed);
                    pc.printf("steer1: %d \n", steer1);
                    pc.printf("steer2: %d \n", steer2);
                    pc.printf("steer3: %d \n", steer3);
                    pc.printf("steer4: %d \n", steer4);
                    flag = true;
              }
             break; 
        default:
            State=CheckS;
            break;
       }
       
}

int main()
{
    //UsartRxFIFO_Init(&RxFIFO);                      //---STEP3---  初始化缓冲区并连接中断函数
    
    pc.attach(callback); 
    pc.printf("Hello");
    Led = 0;
    //char rec;
    
    while(1) 
    {
        if (flag == true) {
            motor();
            flag = false;
        } 
    }
}