/*
本程序实验时,注意将串口调试助手的波特率修改为115200
实验证明:SPI通讯硬件连接中,mosi,miso,sck是专用引脚.而csn,ce,irq都是用的引脚的GPIO功能.
试验中,将本例的D7换成了D12,D8换成了D11,D6换成了D13,实验没有问题.
*/
#include "mbed.h"
#include "nRF24L01P.h"

Serial pc(USBTX, USBRX, 115200); // tx, rx,波特率115200
/*USBTX--PA_2,USBRX--PA_3*/

nRF24L01P my_nrf24l01p(D4, D5, D3, D7, D8, D6);    // mosi, miso, sck, csn, ce, irq   用SPI1通讯, D3灯这种命名方法是根据网站mbed引脚地图中的绿色框得到的,具体见PinNames.h
/*D3--PB_3,D4--PB_5,D5--PB_4,D6--PB_10,D7--PA_8,D8--PA9*/

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
/*LED1--PA_5,LED2--PA_5*/

int main() {
    
    pc.printf("init\r\n");
    
    
    typedef signed char s8;
    s8 Direction = 100,Speed = 100,steer1 = 50,steer2 = 50,steer3 = 50,steer4 = 50;    //typedef int8_t s8:-128~127
    s8 DirectionGoal,SpeedGoal,steer1Goal,steer2Goal,steer3Goal,steer4Goal;    //typedef int8_t s8:-128~127
    //extern Serial bluetoothreceive;
    typedef enum
    {
        CheckS,CheckW,Checka,Checkb,Checkc,Checkd,Checke,Checkf,CheckSum, CheckOver
    }STATE;   //定义枚举类型STATE

// The nRF24L01+ supports transfers from 1 to 32 bytes, but Sparkfun's
//  "Nordic Serial Interface Board" (http://www.sparkfun.com/products/9019)
//  only handles 4 byte transfers in the ATMega code.
/*
nRF24L01+支持从1-32字节的传输,但是Sparkfun的"Nordic Serial Interface Board"板子在ATMega代码中,只处理4字节的传输
*/
    #define TRANSFER_SIZE   8    //每次发送的固定字节数目

    char txData[TRANSFER_SIZE], rxData[TRANSFER_SIZE];
    int txDataCnt = 0;
    int rxDataCnt = 0;

    my_nrf24l01p.powerUp();

    // Display the (default) setup of the nRF24L01+ chip
    //显示nRF24L01+芯片的默认设置
    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress() );
    pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", my_nrf24l01p.getRxAddress() );

    pc.printf( "Type keys to test transfers:\r\n  (transfers are grouped into %d characters)\r\n", TRANSFER_SIZE );

    my_nrf24l01p.setTransferSize( TRANSFER_SIZE );   //设置传输字节数
    my_nrf24l01p.setReceiveMode();   //打开接收
    my_nrf24l01p.enable();      //使能

    while (1) {

        // If we've received anything over the host serial link...如果从与主机连接的串口中接收到消息
        if ( pc.readable() ) {

            // ...add it to the transmit buffer添加到发送缓存
            txData[txDataCnt++] = pc.getc();

            // If the transmit buffer is full如果发送缓存是满的
            if ( txDataCnt >= sizeof( txData ) ) {

                // Send the transmitbuffer via the nRF24L01+
                my_nrf24l01p.write( NRF24L01P_PIPE_P0, txData, txDataCnt );    //发送,这是发送用的函数.txData是发送的内容,txDataCnt是发送的字节数

                txDataCnt = 0;    //计数清零
            }

            // Toggle LED1 (to help debug Host -> nRF24L01+ communication)切换LED1(帮助调试主机->nRF24L01+的通讯)
            myled1 = !myled1;
        }

        // If we've received anything in the nRF24L01+...如果在nRF24L01+中接收到消息
        if ( my_nrf24l01p.readable() ) {

            // ...read the data into the receive buffer将接收到的消息读入接收缓存
            rxDataCnt = my_nrf24l01p.read( NRF24L01P_PIPE_P0, rxData, sizeof( rxData ) );   //接收,这是接收函数,rxData是接收的内容,后面跟着接收的字节数.   问题:赋值给rxDataCnt的目的是什么???

            // Display the receive buffer contents via the host serial link通过主机串口连接显示接收缓存中的内容
            
//            int counter = 0;
            bool flag = false;
            s8 u1Rec; 
            static STATE State = CheckS;// 初始状态待检查
            static s8 PositionTemp[5]={0,0,0,0,0};// 装载数据值a(左右转)b(前后退)c d e f舵机转动角度sum(求和校验)
            
            
            
            for ( int i = 0; rxDataCnt > 0; rxDataCnt--, i++ ) {
                
                pc.putc( rxData[i] );  //打印到串口
                
                
                switch(State)
                {
                case CheckS:
                    if(u1Rec==(s8)'S'){
                        State=CheckW;//准备跳转至数据读取
                    }else
                        State=CheckS;
                        break;
                case CheckW:
                    if(u1Rec==(s8)'W'){
                        State=Checka;
                    }else if(u1Rec==(s8)'S')
                            State=CheckW;
                        else 
                            State=CheckS;
                            break;
                case Checka:
                    PositionTemp[0]=u1Rec;
                    State=Checkb;
                    break;
                case Checkb:
                    PositionTemp[1]=u1Rec;
                    State=Checkc;
                    break;
                case Checkc:
                    PositionTemp[2]=u1Rec;
                    State=Checkd;
                    break;
                case Checkd:
                    PositionTemp[3]=u1Rec;
                    State=Checke;
                    break;
//                case Checke:
//                    PositionTemp[4]=u1Rec;
//                    State=Checkf;
//                    break;
//                case Checkf:
//                    PositionTemp[5]=u1Rec;
//                    State=CheckSum;
//                    break;
                case CheckSum:
                    PositionTemp[4]=u1Rec;
                    State=CheckOver;
                    break;
                case CheckOver:
                    if(u1Rec==(s8)'E'){
                        State=CheckS;//准备跳转至数据读取
                    } else {
                        State=CheckS;
                        break;
                    }
                    if(PositionTemp[4]==(s8)(PositionTemp[0]+PositionTemp[1]+PositionTemp[2]+PositionTemp[3]))
                    {
                        DirectionGoal = PositionTemp[0];
                        SpeedGoal     = PositionTemp[1];
                        steer1Goal    = PositionTemp[2];
                        steer2Goal    = PositionTemp[3];
//                        steer3Goal    = PositionTemp[4];
//                        steer4Goal    = PositionTemp[5];
//                        pc.printf("E\n");     //调试用,用于显示程序是否运行到这里
//                        pc.printf("Speed: %d \n", Speed);     //调试用,用于显示程序是否 正确接收到数据
//                        pc.printf("steer1: %d \n", steer1);
//                        pc.printf("steer2: %d \n", steer2);
//                        pc.printf("steer3: %d \n", steer3);
//                        pc.printf("steer4: %d \n", steer4);
                            flag = true;      //状态判断,用于判断蓝牙串口是否接收到控制指令
                    }
                    break; 
                default:
                    State=CheckS;
                    break;
            }

            // Toggle LED2 (to help debug nRF24L01+ -> Host communication)切换LED2(帮助调试nRF24L01+->主机的通讯)
            myled2 = !myled2;
        }
    }
}
}
