// Basic example show how to read a tag uid.
// you can use i2c, spi, hsu interface.
//
// Assembled by dotnfc as Arducleo Sample
// 2016/09/10



#include "mbed.h"
#include "PN532.h"
#include "PN532_HSU.h"
#include "PN532_SPI.h"
#include "PN532_I2C.h"

DigitalOut ledBrd (PC_13);                                                      // 板载led
DigitalOut ledNFC (PC_7);                                                       // 状态led
DigitalOut rstNFC (PB_5);                                                       // pn532读卡器复位控制

PwmOut buz(PB_1);

Serial pc(PB_10, PB_11);                                                         //调试串口

// ----------------------------------------- HSU
HardwareSerial pn532_hsu (PA_2, PA_3);                                          //pn532连接的串口,需要时取消这两句注释
PN532_HSU pn532_if (pn532_hsu);

// ----------------------------------------- SPI
//SPI pn532_spi (SPI_MOSI, SPI_MISO, SPI_SCK);                                  //pn532连接的SPI,需要时取消这两句注释
//PN532_SPI pn532_if (pn532_spi, SPI_CS);

// ----------------------------------------- I2C
//I2C pn532_i2c (I2C_SDA, I2C_SCL);                                             //pn532连接的I2C,需要时取消这两句注释
//PN532_I2C pn532_if (pn532_i2c);



PN532 nfc(pn532_if);

/*==============================================================================
 * \复位pn532数卡器
 */
void reset_chip (void)
{
    rstNFC = 0;
    wait_ms (100);
    rstNFC = 1;
}


/*==============================================================================
 * \初始化外设
 */
void setup(void)
{
    ledBrd = 0;
    ledNFC = 0;
    reset_chip ();

    uint32_t versiondata = 0;
    pc.baud(115200);                                                            //波特率设置为115200
    pc.printf ("Hello!\r\n");

    /*while (1) {
        nfc.begin();
        //nfc.SAMConfig();
        versiondata = nfc.getFirmwareVersion();
        if (! versiondata) {
            pc.printf("Didn't find PN53x board\n\n");
            wait_ms(500);
        } else {
            break;
        }
    }*/
    nfc.begin();

    // Got ok data, print it out!
    pc.printf ("Found chip PN5%02X , Firmware ver. %d.%d\r\n",
               (versiondata>>24) & 0xFF,
               (versiondata>>16) & 0xFF,
               (versiondata>>8) & 0xFF);

    // 设置从卡片读取的c重复尝试的最大重试次数。
    // 这使我们避免永远的等待读取一个卡，永远等待是PN532默认行为
    nfc.setPassiveActivationRetries(0xFF);

    // 配置板读取RFID标签
    nfc.SAMConfig();

    pc.printf ("\nWaiting for an ISO14443A card\r\n");
}


/*==============================================================================
 * \发现标签
 */
void loop(void)
{
    bool success;
    uint8_t uid[] = { 0, 0, 0, 0, 0, 0, 0 };                                    // 存储返回UID值的缓冲
    uint8_t uidLength;                                                          // UID的长度(根据ISO14443A卡类型4或7个字节)

    // 配置板读取RFID标签
    nfc.SAMConfig();

    // 等待一个ISO14443A类型的卡(如Mifare卡等). 当发现一个时,'uid'会被UID填充,并且uid长度会指出该uid是4字节(典型的Mifare)或7字节(超轻Mifare),100是超时时间（单位是毫秒，ms)
    success = nfc.readPassiveTargetID(PN532_MIFARE_ISO14443A, &uid[0], &uidLength, 100);

    printf ("\r\n");

    if (success) {
        tone (buz, 800);                                                        // 打开蜂鸣器
        ledNFC = 1;                                                             // 打开led

        pc.printf("Found a card!\r\n");
        
//    nfc.writeGPIOP7((1<<PN532_GPIO_P71)); //把P70,P72设置为1，其余P7设置为0
       nfc.writeGPIOP3((1<<PN532_GPIO_P31)|(1<<PN532_GPIO_P30));                //把P30,P32设置为1，其余P3设置为0
       nfc.writeGPIOP7((1<<PN532_GPIO_P71));                                    //把P70,P72设置为1，其余P7设置为0
 //   nfc.writeGPIOP7(0); //把P7全部设置为0

        pc.printf("UID Length: %d bytes\r\n", uidLength);
        pc.printf("UID Value: ");

        for (uint8_t i=0; i < uidLength; i++)
            pc.printf(" 0x%02X", uid[i]);

        pc.printf("\r\n");

        wait_ms (100);
        tone (buz, 0);                                                          // 关闭蜂鸣器

        // 等到移开卡时
        while (nfc.readPassiveTargetID(PN532_MIFARE_ISO14443A, &uid[0], &uidLength, 500)) {}
        nfc.writeGPIOP3(0);
        nfc.writeGPIOP7(0);
        ledNFC = 0;                                                             // 关闭led
    } else {
        // PN532可能等待卡片超时
        pc.printf("\nTimed out waiting for a card\r\n");
        ledNFC = 0;
        wait_ms (200);
    }
}


/*==============================================================================
 * \main入口
 */
int main()
{
    setup();

    while (1)
        loop ();
}

