#include "Moter3_L298N.h"
#include "mbed.h"
#define HIGH 1
#define LOW 0

Motor_3::Motor_3(PinName dia1,PinName dia2,PinName pwa):
    _dia1(dia1),_dia2(dia2),_pwa(pwa),_paspeed(0)
{
    //init
    DigitalOut pda1(_dia1,LOW);
    DigitalOut pda2(_dia2,LOW);    
}

void Motor_3::mv(float speed)
{
    PwmOut mypwa(_pwa);
    mypwa.period_ms(20);
    speed=speed/100*20/1000;
    if(speed>0)
    {
         DigitalOut mydia1(_dia1,HIGH);
         DigitalOut mydia2(_dia2,LOW);
        _paspeed=speed;
        mypwa.pulsewidth(_paspeed);
    }
    else if (speed<0)
    {
        speed=abs(speed);
        DigitalOut mydia1(_dia1,LOW);
        DigitalOut mydia2(_dia2,HIGH);
        _paspeed=speed;
        mypwa.pulsewidth(_paspeed); 
    }
    else 
    {
        speed=abs(speed);
        DigitalOut mydia1(_dia1,LOW);
        DigitalOut mydia2(_dia2,LOW);
        _paspeed=speed;
        mypwa.pulsewidth(_paspeed); 
    }
        
}
void Motor_3::stop()
{
    DigitalOut pda1(_dia1,LOW);
    DigitalOut pda2(_dia2,LOW);
}