#define HIGH 1
#define LOW 0
#include "mbed.h"
#include <string>
typedef bool boolean;
typedef std::string String;
#include "nRF24L01P.h"
#include "MPU6050.h"

char rxdata[12] ;
float Yaw;
float Pitch;
float Roll;
int Power;
int Yaw_t;
int Pitch_t;
int Roll_t;
long CycleCount;
long ReceiveCount;

#define NRF24_TRANSFER_SIZE 12
nRF24L01P nrf24_PB_15(PB_15,PB_14,PB_13,PB_6,PB_5,PB_7);
Serial Serial_2(PA_2,PA_3);
mpu6050 mpu6050_I2C_1(PB_9,PB_8);
DigitalOut myDigitalOutPA_7(PA_7);
DigitalOut myDigitalOutPA_6(PA_6);

int main() {
nrf24_PB_15.powerUp();
nrf24_PB_15.setTransferSize( NRF24_TRANSFER_SIZE );
nrf24_PB_15.setReceiveMode();
nrf24_PB_15.setRxAddress(12345ull);
nrf24_PB_15.setTxAddress(12345ull);
nrf24_PB_15.enable();

Serial_2.baud(9600);

mpu6050_I2C_1.Init();

CycleCount = 0;
ReceiveCount = 0;
while (true) {
CycleCount = CycleCount + 1;
mpu6050_I2C_1.receiveData(&Yaw,&Pitch,&Roll);
Serial_2.printf("Yaw=%.2f, Pitch=%.2f, Roll=%.2f \n",Yaw,Pitch,Roll);
if (nrf24_PB_15.readable()) {
ReceiveCount = ReceiveCount + 1;
myDigitalOutPA_7.write((ReceiveCount % 2 == 0));
nrf24_PB_15.read( NRF24L01P_PIPE_P0, rxdata, NRF24_TRANSFER_SIZE);
if (rxdata[0] == 82) {
Power = rxdata[1];
Yaw_t = rxdata[2] - 45;
Pitch_t = rxdata[3] - 45;
Roll_t = rxdata[4] - 45;
Serial_2.printf("Power=%d, Yaw=%d, Pitch=%d, Roll=%d \n",Power,Yaw_t,Pitch_t,Roll_t);
}
}
myDigitalOutPA_6.write((CycleCount % 2 == 0));
wait(0.05);
}

}