/*
cpp文件：
类名::构造函数:
    _对象名（属性）        //给类中的变量赋值，也可以在花括号中用等于号赋值，主要针对是构造函数中的变量
{
    _对象名.函数(参数)；        //在生成构造函数的时候执行这个代码块
}

void 类名::函数名(参数)
{
    函数体；
}
*/

#include "IO_pwm.h"
#include "mbed.h"

IO_pwm::IO_pwm(PinName n):
    _n(n)
{
//    DigtalOut mypwm(_n);
    on_delay=0;
    off_delay=0;  
}
void IO_pwm::toggleOn(void) {
    DigitalOut mypwm(_n);
    mypwm = 1;
    timer.attach_us(this,&IO_pwm::toggleOff, on_delay);                         //类里启动中断,函数名需要特殊处理,按照这个方式拷贝就可以了
}

void IO_pwm::toggleOff(void) {
    DigitalOut mypwm(_n);
    mypwm = 0;
    timer.attach_us(this,&IO_pwm::toggleOn, off_delay);
}

// 周期p_us = signal period in micro_seconds
// 占空比dc   = signal duty-cycle (0.0 to 1.0)
void IO_pwm::pwm_io(int p_us, float dc) {
    DigitalOut mypwm(_n);
    timer.detach();
    if ((p_us == 0) || (dc == 0)) {
        mypwm = 0;
        return;
    }
    if (dc >= 1) {
        mypwm = 1;
        return;
    }
    on_delay = (int)(p_us * dc);
    off_delay = p_us - on_delay;
    this->toggleOn();
}
