#include "mbed.h"
#include "QEI.h"

//两个轮子L298N
DigitalOut w1(PB_6);
DigitalOut w2(PB_7);
DigitalOut w3(PB_8);
DigitalOut w4(PB_9);
PwmOut mypwm1(PA_9);
PwmOut mypwm2(PA_8);
//调试串口
Serial pc(PB_10, PB_11);

Ticker toggle_time_ticker;
//编码器1-4
QEI wheel(PA_2, PA_3, NC, 11, QEI::X4_ENCODING);                //买来的电机自带编码器,说明书上有电机每转一圈编码器发生11个信号
QEI wheel2(PA_6, PA_7, NC, 11, QEI::X4_ENCODING);

int x,y;
float a= 0.01, b = 0.00860454;
void time_ticker();
void serialread();

int main()
{
    mypwm1.period_ms(10);
    mypwm2.period_ms(10);
    
    toggle_time_ticker.attach(&time_ticker, 0.2);       //使能ticker中断,0.2s产生一次.中断函数用于获取每个轮子的计数值
    
    pc.attach(&serialread);
    
    mypwm1.pulsewidth(a);
    mypwm2.pulsewidth(b);
    wheel.reset();      //reset函数,将编码器计数值赋0(初始化编码器,开始计数)
    wheel2.reset();
    w1 = 0;
    w2 = 0;
    w3 = 0;
    w4 = 0; 
    while(1)
    {
        
    }   
}

void time_ticker(){
    //获取一个轮子的编码器读到的数和旋转方向
    x = wheel.getPulses();      
    x = x/44;       //将编码器计数值转化成轮子旋转的圈数
    wheel.getState();   //获取旋转方向,返回值为1--顺时针, -1--逆时针         
    y = wheel2.getPulses();
    y = y/44;       //将编码器计数值转化成轮子旋转的圈数
    wheel2.getState();  //获取旋转方向,返回值为1--顺时针, -1--逆时针
    
    wheel.reset();
    wheel2.reset();
    pc.printf("x:%d y:%d\n",x,y);
}

void serialread(){
    switch (pc.getc())
  {
    case '1':
          w1=0;
          w4=0;
        break;
    case '2':
          w1=1;
          w4=1;
        break;
    default:
        break;
  }
}