#include <string>
typedef bool boolean;
typedef std::string String;

void voice_play(String value_, Serial* ser) {
    const char* value = value_.c_str();
    int size = strlen(value);
    int data_length = 1+2+1+1+size;
    int* data = (int*)malloc(sizeof(int)*(data_length+1));
    
    int start = 0xfd;
    int length = size + 3;
    int length_h = length / 256;
    int length_l = length % 256;
    int command = 0x01;
    int param = 0x01;
    
    data[0] = start;
    data[1] = length_h;
    data[2] = length_l;
    data[3] = command;
    data[4] = param;
 
    for (int i=5; i<5+size; i++) {
        data[i] = value[i-5];
    }
 
    // calculate check bit
    int check_bit = data[0];
    for (int i=1; i<data_length; i++) {
        check_bit ^= data[i];
    }   
    data[data_length] = check_bit;
 
    for (int i=0; i<=data_length; i++) {
        ser->putc(data[i]);
    }
    
    free(data);
    
    //int recv = ser->getc();
    //PC.printf("%c", recv);
    //int done = ser->getc();
    //PC.printf("%c", done);   
}