#include "mbed.h"
#include "TextLCD.h"
//slave

AnalogIn pot(PTB1);  // postavi pin
InterruptIn button(PTD4);
DigitalOut mod1(PTD0);
DigitalOut mod2(PTD2);
DigitalOut mod3(PTD3);
Timer debounce;
I2CSlave i2c_slave(PTC11, PTC10); //sda, scl
TextLCD lcd(PTB8,PTB9,PTB10,PTB11,PTE2,PTE3,TextLCD::LCD16x2); // LCD
Serial pc(USBTX,USBRX);

float temp;
float temp_k;
float temp_f;
int rec;
char podaci[2];
char temp_read[2];
const int addr_slave = 0x80;
int state = 0;
int old = 0;
//int buttonPoll = 0;

float pretvori_temp(){
    temp = 0.0625 * (((temp_read[0] << 8) + temp_read[1]) >> 4); //konverzija u float vrijednost deg C
    return temp;
    }
    
void isr1(){
  if (debounce.read_ms() > 200) {
    state = old + 1;
    old = state;
    debounce.reset();
    }
}


int main(){
    mod1 = 1;
    mod2 = 0;
    mod3 = 0;
    
    lcd.cls();
    wait(0.01);
    i2c_slave.frequency(100000);
    i2c_slave.address(addr_slave<<1);
    
    debounce.start();
    button.rise(&isr1);
    
    while(1){
        float Ain = pot.read();
        float temp_ref = 17.0 + ((float)Ain*10.0); // 17 - 27 C T_ref
        short temp_ref_100 = temp_ref*100;
        
        rec = i2c_slave.receive();
        
        switch(rec){
            case 0: break;
            case 1:
            wait_us(50); //clock-stretching
            podaci[0] = temp_ref_100>>8; //MSB
            podaci[1] = temp_ref_100; //LSB
            i2c_slave.write(podaci,2);
            break;
            case 2:
            case 3:
            i2c_slave.read(temp_read,2);
            pretvori_temp();
            temp_k= temp + 273.15; // T(K) = t(C);
            temp_f= (temp*1.8)+32; //(0°C × 9/5) + 32 = 32°F
            lcd.cls();
            wait(0.01);
            switch(state){
                case 1: //celsius
                mod1 = 1;
                mod2 = 0;
                mod3 = 0;
                lcd.printf("Mod 1 - Celsius\nT = %.2f C", temp);
                //pc.printf("Primljena temp: %2f C\n\r", temp);
                wait(0.5);
                break;
                case 2: //kelvin
                mod1 = 0;
                mod2 = 1;
                mod3 = 0;
                lcd.printf("Mod 2 - Kelvin\nT = %.2f K", temp_k); 
                //pc.printf("Primljena temp: %2f K\n\r", temp_k);
                wait(0.5);
                break;
                case 3: //fahrenheit
                mod1 = 0;
                mod2 = 0;
                mod3 = 1;
                lcd.printf("Mod 3 - Fahr\nT = %.2f F", temp_f); 
                //pc.printf("Primljena temp: %2f F\n\r", temp_f);
                wait(0.5);
                break;
                case 4:
                mod1 = 0;
                mod2 = 0;
                mod3 = 0;
                lcd.printf("Temp ref:\nT = %.2f C", temp_ref);
                //pc.printf("Poslana temp_ref: %2f C\n\r", temp_f);
                wait(0.5);
                break;
                default: //celsius
                old = 1;
                mod1 = 1;
                mod2 = 0;
                mod3 = 0;
                lcd.printf("Mod 1 - Celsius\nT = %.2f C", temp);
                //pc.printf("Primljena temp: %2f C\n\r", temp);
                wait(0.5);
                break;
                }
            break;
            default:break;
            }
            
        }
    }