#include "mbed.h"
#if defined (TARGET_KL05Z)

#else
#error TARGET NOT DEFINED
#endif

PinName const SDA = PTB4;
PinName const SCL = PTB3;

I2C i2c(SDA, SCL);  //construct I2c object

const int addr = 0x40<<1;  //i2c address of AS5013
Serial pc(USBTX, USBRX); //optional, but needed to set faster baud
char data[7];
//void init_AS5013(void);

void init_AS5013(){
    int8_t statusF=0;
    //i=0;
    wait(0.1);
    data[0]=0x0f;
    data[1]=0x02;
    i2c.write(addr,data,2); //reset part. write 2 to reg 0x0f
    wait(.01);
    //printf("two...");
 /*
    while(statusF != 0xf0) {
        data[0]= 0x0f;
        i2c.write(addr,data,1);  //set up to read register 0x0f
        i2c.read(addr,data,1);
        statusF = data[0] & 0xfe;
        wait(0.01);
        printf("0x%x2 0x%x2...",statusF,data[0]);
    }
 */   
    //printf("three...");
    //set up the gain factor
    data[0] = 0x2d; //set up write to register 0x2d with scalling factor
    data[1] = 0x04;    //scaling factor
    i2c.write(addr,data,2);

    }

int main() {
    int8_t x,y;         //x y values to be printed to terminal
    uint8_t statusF;    //status flag
    pc.baud (115200);   
    //printf("start...");
    init_AS5013();      //reset and initialze the AS5013
    //printf("one...");
    while (1) {
        wait(0.1);
        statusF =0;
        data[0] = 0x0f;
        i2c.write(addr, data, 1);   //set to read address 0x0f
        i2c.read(addr, data, 3);    //read data at register 0x0f, 0x10, 0x11
        statusF = data[0];          //get status byte
        if(statusF & 0x01){
            x=data[1];      //get x
            y=data[2];      //get y
            printf(" %d %d", x,y);  //output result  
            printf("\n");
            }
            else{
                pc.printf("error 0x%x\n",statusF);  //should not get here
                }
        
    }
}

