//=================================================================
// The main program file.
//
// CoplayerYright 2021 Georgia Tech.  All rights reserved.
// The materials provided by the instructor in this course are for
// the use of the students currently enrolled in the course.
// CoplayerYrighted course materials may not be further disseminated.
// This file must not be made publicly available anywhere.
//==================================================================

// External libs
#include <stdlib.h>

// Project includes
#include "globals.h"
#include "hardware.h"
#include "city_landscape_public.h"
#include "missile_public.h"
#include "player_public.h"


#define CITY_HIT_MARGIN 1
#define CITY_UPPER_BOUND (SIZE_Y-(LANDSCAPE_HEIGHT+MAX_BUILDING_HEIGHT))

int num_city_g = 4;
int currScore = 0;  // current score
int topScore = 0;  // top score
int level = 1;  // game level
// function prototypes
void set_random_seed(Timer);
int city_landscape_update(void);
int was_player_hit(void);
void missile_contact(void); 
void endGame(void);
void display_topScore(void);
//void explosion(int leftSide, int rightSide, int subHeight);





int main()
{
    GameInputs inputs; 
    // First things first: initialize hardware
    ASSERT_P(hardware_init() == ERROR_NONE, "Hardware init failed!");
    pc.printf("Program Starting");

    // Game state variables
    int num_remain_city = 4; // number of cities currently on the landscape
    int player_alive = 3; // 1 if alive, 0 if hit
    int check_hit = 1;
    //int topScore = 0;
    
    
    testDLL();
    // Timer to measure game update speed (secondarily used to generate random seed)
    Timer t;
    int dt; // delta time
    set_random_seed(t); // Already implemented.
    
    //Initialization functions (already implemented)
    city_landscape_init(num_city_g);
    missile_init();
    player_init();        
    pc.printf("Initialization complete\n");

     
   
    
    while(1)
    {
        
        t.start();
        
        
        
        uLCD.locate(1,0);
        //uLCD.set_font_size(1, 1);
        uLCD.printf("Score:%d", currScore);
        
        uLCD.locate(11,0);
        //uLCD.set_font_size(2, 2);
        uLCD.printf("Lives:%d", player_alive);
        
        
        
        inputs = read_inputs();
        
        // Generate new missiles and draw all active missiles at current 
        // positions. (Already implemented.)
        missile_generator();
        
        
        
        // You must write the code to dispatch to the correct action (e.g., 
        // player_moveLeft/Right, player_fire, etc.) based on the inputs read.
        // You must also implement player_moveLeft/moveRight/fire (see player
        // module).
        GameInputs in = read_inputs();
        
        if(in.ax > 0.05) {
               player_moveRight();
        }
        
        if(in.ax < -0.05) {
               player_moveLeft(); 
        }
        
        if(inputs.b2){
                player_fire();
        }
             
        
        
        
        // Draw all active anti-missiles (aka player missiles) at current 
        // positions. (Already implemented.)
        player_missile_draw();
        
        // Detect missile collisions with city/land and update status.
        // You need to implement this (see specification below).
        num_remain_city = city_landscape_update();
        
        // Detect missile collision with player aircraft.
        // You need to implement this (see specification below).
       // player_alive = was_player_hit(); //returns 0 if player is hit; else 1
        
        // Detect missile collisions with player anti-missiles.
        // You need to implement this (see specification below).
        missile_contact();
        
        check_hit = was_player_hit();
        
        
        if(check_hit == 1) {
            if(player_alive == 0) {      // if player out of lives after being hit, game over
                player_destroy();
                break;
            }
           player_alive = player_alive - 1;  // lives decremented by 1 
        }
        
        if(num_remain_city == 0 || player_alive == 0) { // if all cities are destroyed or player is out of lives, game over
            break;
        }
    
        // You must complete the implementation of this function in hardware.cpp:
        //inputs = read_inputs();

                 
    
        
        // Compute update time to control timing of the game loop.
        // (Already implemented... you're welcome.)
        t.stop();
        dt = t.read_ms();
        if (dt < 100) wait_ms(100 - dt);
    }
    pc.printf("out of main loop\n");
    
    
    
     
    
    
    // You must write code to free up any dynamically allocated objects such
    // as lists of missiles (hint: destroyList can be used for doubly linked
    // lists).
    DLinkedList* missileList = get_missile_list();
    destroyList(missileList);
    PLAYER pmissile = player_get_info();
    DLinkedList* pmiss = pmissile.playerMissiles;
    destroyList(pmiss);
    
    endGame();
}


void explosion(int status, int a, int b, int waitTime) {
        if(status == 0) { // explosion animation for missile
            uLCD.circle(a, b, 10, 0xFCC603);
            wait(waitTime);
            uLCD.circle(a, b, 10, BACKGROUND_COLOR); // yellow explosion
            wait(waitTime);
            uLCD.circle(a, b, 8, 0xFCC603); 
            wait(waitTime);
            uLCD.circle(a, b, 8, BACKGROUND_COLOR); // yellow explosion
            wait(waitTime);
            uLCD.circle(a, b, 6, 0xFCC603);
            wait(waitTime);
            uLCD.circle(a, b, 6, BACKGROUND_COLOR);  // yellow explosion
            
        }
        
        if(status == 1) {  // destruction animation for city and player
            uLCD.circle(a, b, 10, 0xFF00FF); // blue explosion
            wait(waitTime);
            uLCD.circle(a, b, 10, BACKGROUND_COLOR);
            wait(waitTime);
            uLCD.circle(a, b, 8, 0xFF00FF); // blue explosion
            wait(waitTime);
            uLCD.circle(a, b, 8, BACKGROUND_COLOR);
            wait(waitTime);
            uLCD.circle(a, b, 6, 0xFF00FF); // blue explosion
            wait(waitTime);
            uLCD.circle(a, b, 6, BACKGROUND_COLOR);
        }
    }







/** Detect whether any missile has hit a city and if so, call 
    city_demolish (hint: city_get_info may be useful).
    Also, if any missile has hit a city or the landscape,
    mark the missile's status as MISSILE_EXPLODED 
    which will cue the missile's deletion and erasure from the screen 
    on the next missile_generator call.
    @return  Number of remaining cities.
*/
int city_landscape_update(void){
    // Complete this function.
    
    int j;
    const int i = num_city_g;
    int c1, c2, c3, c4;
    int leftSide, rightSide, subHeight;
    DLinkedList* miss = get_missile_list();
    LLNode* currMissile = miss->head;
    
    while(currMissile) {
        MISSILE* attack = (MISSILE*) currMissile->data;
        for(j = 0; j <= i; j++) {
            CITY activeCity = city_get_info(j);
            switch(activeCity.status) {
                case DEMOLISHED:
                    break;
                case EXIST:
                    leftSide = activeCity.x;
                    rightSide = activeCity.width + leftSide;
                    subHeight = 128 - activeCity.height;
                    c1 = attack->x - rightSide;
                    c2 = leftSide - attack->x;
                    c3 = 128 - attack->y;
                    c4 = subHeight - attack->y;
                    
                    if( (c1<=0) && (c2<=0) && (c3>=1) && (c4<=0) ) { //city collision starts
                        activeCity.status = DEMOLISHED;
                        city_demolish(j);
                        attack->status = MISSILE_EXPLODED;
                        num_city_g = num_city_g - 1; // remaining cities
                        explosion(1,0.5*(leftSide + rightSide),subHeight,0.1);
                    }
            }   
        }
        currMissile = currMissile->next;
    }
    
    return num_city_g;
}

/** Detect whether any missile has hit the player aircraft and if so, call 
    player_destroy (hint: player_get_info may be useful) and mark the 
    missile's status as MISSILE_EXPLODED which will cue the missile's deletion
    and erasure from the screen on the next missile_generator call.
    @return 1 if the player aircraft was hit and 0 otherwise.
*/
int was_player_hit(){
    
    int enemyX, enemyY;
    
    PLAYER activePlayer = player_get_info();
    DLinkedList* miss = get_missile_list();
    LLNode* enemyMiss = miss->head;
    while(enemyMiss) {
        MISSILE* enemy = (MISSILE*) enemyMiss->data;
        enemyX = enemy->x;
        enemyY = enemy->y;
        if( ((enemyY - activePlayer.y < 1) && (activePlayer.y - enemyY) < 5) && ((activePlayer.x - enemyX) < 1 && (enemyX - activePlayer.x) < 5 )) {
            enemy->status = MISSILE_EXPLODED;   
            return 1;    // when player is hit, return back to while loop
        }
        enemyMiss = enemyMiss->next;
    }
    return 0;
    
    
}

/** Detect whether any missile has hit any player missile and if so, 
    mark the status of both the missile and the player missile as 
    MISSILE_EXPLODED which will cue the missile's deletion and erasure 
    from the screen on the next missile_generator call.
*/
void missile_contact(void) {
    int enemyX, enemyY, playerX, playerY;
    
    PLAYER activePlayer = player_get_info();
    DLinkedList* pmiss = activePlayer.playerMissiles;
    
    DLinkedList* miss = get_missile_list();
    LLNode* pMiss = pmiss->head;
    LLNode* enemyMiss = miss->head;
    MISSILE* enemy;
    PLAYER_MISSILE* defend;
    while(pMiss) {
        defend = (PLAYER_MISSILE*) pMiss->data;
        playerX = defend->x;
        playerY = defend->y;
        while(enemyMiss) {
            enemy = (MISSILE*) enemyMiss->data;
            enemyX = enemy->x;
            enemyY = enemy->y;
            if((enemyX - playerX)*(enemyX - playerX)+(enemyY - playerY)*(enemyY - playerY) < 100) { // distance < radius
                defend->status = PMISSILE_EXPLODED;
                enemy->status = MISSILE_EXPLODED;
                explosion(0,0.5*(enemyX + playerX),0.5*(enemyY + playerY),0.1);
                currScore = currScore + 1;        // player score increeased by 1
            }
            enemyMiss = enemyMiss->next;
        }
        if(enemyY > 128) {
            enemy->status = MISSILE_EXPLODED;
        }  
        pMiss = pMiss->next;  
    }
    
    
}

/* We need a random number generator (e.g., in missile_create to generate
   random positions for the missiles to start, making the game different
   every time).  C provides a pseudo random number generator (in stdlib) but
   it requires that we give it a different seed for each new game.  A common
   way to do this is to sample a clock and use the time as the seed.  However
   if we do this by starting a simple Timer t when the mbed starts running the 
   program and then sample it (t.read_ms), we will always get exactly the same
   time sample -- t.read_ms will always occur at the same time in the program's
   execution.  We introduce variability in when we sample the time by waiting
   for the user to push any button before we call t.read_ms.
*/
void set_random_seed(Timer t) {
    GameInputs inputs; 
    t.start();
    uLCD.printf("Push any button to start.\n");
    while(1){
      inputs = read_inputs();
      if (inputs.b1 || inputs.b2 || inputs.b3) break;
      }
    uLCD.cls();
    t.stop();
    int seed = t.read_ms();    
    srand(seed);
    }

       // You must write code to detect and implement game over.        
    void endGame() {
        uLCD.cls();
        uLCD.locate(5,3);
        uLCD.printf("Game Over");
        uLCD.locate(5,4);
        uLCD.printf("Score: %d", currScore);
        if(topScore <= currScore && currScore != 0) {
            topScore = currScore;
            uLCD.locate(5,6);
            uLCD.printf("High Score!");
            uLCD.locate(5,9);
            uLCD.printf("Good job"); 
        }
        wait(10);
        uLCD.cls();
    }  
    
     // display highest score
    void display_topScore() {
        uLCD.locate(4,7);
        uLCD.printf("Highest score: %d", topScore);
        wait(10);
        uLCD.cls();    
    }

