#include "mbed.h"
#include "MODSERIAL.h";
#include "FastPWM.h" ;
#include "QEI.h" ;
#include "Motor.h" ;

Serial pc(USBTX,USBRX);

AnalogIn pot(PTB2);
InterruptIn button(PTB3);

FastPWM motor(D5);
FastPWM led(PTA1);

int pulses = 131;
QEI wheel (D13,D12,NC,pulses);

int pin = 1;

void flip()
{
    pin=!pin;
}


int main()
{ 
    printf("Control with dial\n");
    button.rise(&flip);
    while(true)
        {
            if (pin == 1)
                {
                led.write(pot);
                wait(0.1);
                motor.write(pot);
                //printf("motor speeed is (%f)\n\r",pot.read());
                //printf("pulse number is (%i)\n\r",wheel.getPulses());
                }
            else
                {
                led.write(1-pot);
                wait(0.1);
                motor.write(-pot);
                //printf("motor speeed is (%f)\n\r",pot.read());
                //printf("pulse number is (%i)\n\r",wheel.getPulses());
                }
        }
}