// Sweep the motor speed from full-speed reverse (-1.0) to full speed forwards (1.0)
 
#include "mbed.h"
#include "Motor.h"
#include "uLCD_4DGL.h"
#include "Servo.h"

Serial blue(p28,p27);
BusOut myled(LED1,LED2,LED3,LED4);

Motor left(p21, p15, p19); // pwm, fwd, rev
Motor right(p22, p18, p16);
Servo arm(p23);
Servo handle(p24);

union f_or_char {
    float f;
    char  c[4];
};

int main()
{ 
    char bchecksum=0;
    char temp=0;
    union f_or_char x,y,z;
    char bnum=0;
    char bhit=0;
    arm = 0.9;
    handle = 0.9;
    
    while(1) {
       if (blue.readable()) {
                if (blue.getc()=='!') {
                    if (blue.getc()=='B') { //button data packet
                        bnum = blue.getc(); //button number
                        bhit = blue.getc(); //1=hit, 0=release
                        if (blue.getc()==char(~('!' + 'B' + bnum + bhit))) { //checksum OK?
                            switch (bnum) {
                                case '1': //number button 1:
                                    if (bhit=='1') 
                                        arm = arm + 0.05;
                                    break;
                                case '2': //number button 2
                                    if (bhit=='1') 
                                        handle = handle + 0.1;
                                    break;
                                case '3': //number button 3
                                    if (bhit=='1') 
                                    {
                                        if (arm.read() <= 0.5)
                                            arm = arm;
                                        else
                                            arm = arm - 0.05; 
                                    }
                                    break;
                                case '4': //number button 4
                                    if (bhit=='1')
                                    {
                                        if (handle.read() <= 0.5 & arm.read() <= 0.5)
                                            handle = handle;
                                        else
                                            handle = handle - 0.1; 
                                        //printf("position = %.1f\n", handle.read());    
                                    }
                                    break;
                                case '5': //button 5 up arrow
                                    if (bhit=='1') {
                                        left.speed(-1.0);
                                        right.speed(-1.0);
                                    } else {
                                        left.speed(0);
                                        right.speed(0);
                                    }
                                    break;
                                case '6': //button 6 down arrow
                                    if (bhit=='1') {
                                        left.speed(1.0);
                                        right.speed(1.0);
                                    } 
                                    else {
                                        left.speed(0);
                                        right.speed(0);
                                    }
                                    break;
                                case '7': //button 7 left arrow
                                    if (bhit=='1') {
                                        left.speed(-1.0);
                                        right.speed(1.0);
                                    } 
                                    else {
                                        left.speed(0);
                                        right.speed(0);
                                    }
                                    break;
                                case '8': //button 8 right arrow
                                    if (bhit=='1') {
                                        left.speed(1.0);
                                        right.speed(-1.0);
                                    } 
                                    else {
                                        left.speed(0);
                                        right.speed(0);
                                    }
                                    break;
                            }
                        }
                    }
                }
            } // end readable
    }
}