
 #include "string" 
 #include "mbed.h"
#include "ble/BLE.h"
#include "BLE.h"
#include "ble/services/UARTService.h"
#include "UARTService.h"

#include "AC_PWM/AC_PWM.h"

BLEDevice  ble;
DigitalOut led1(LED1);

AnalogIn   AVsens(PC_1);
AnalogIn   AVbuss(PC_0);

DigitalIn Stopp(USER_BUTTON);

UARTService *uartServicePtr;


Timeout WaitCall;
Timer t;
Timer t2;
Ticker ticker;

float Vsens=0;
int intVsensMean=0;
float arryVsens[901];
float arryVbuss[901];
float Vbuss;

bool starttic = false;
bool run = false;
bool configs = false;

int BLEfreq=30;
char BLEDicert = 'R';

char runSK = 'S'; //Stopp Kjor 



    
    
void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)
{

    ble.startAdvertising();
}



void periodicCallback(void)
{
   
   
}

void WaitCalling ()
{
    
}


void onDataWritten(const GattWriteCallbackParams *params)
{
    printf("BLE %s \n", params->data);
    
    if ((uartServicePtr != NULL) && (params->handle == uartServicePtr->getTXCharacteristicHandle())) {
       uint16_t bytesRead = params->len;
        
      string s="";
      s = *params->data;
      string s2="";
      
      

    char samp[bytesRead];

    
    
    for (uint32_t i = 0; i < bytesRead+1; i++)
    {
               
                samp[i-1]=params->data[i];//første er kontrol bit resten er databit
    }
    
    s2= samp;

        if (s == "F"){
            
            BLEfreq = atoi(samp);
            
            if (BLEfreq>1 && BLEfreq<100){
               printf("BLE FREQ %d \n",BLEfreq);
                AC_PWM(BLEfreq,BLEDicert); 
                ble.updateCharacteristicValue(uartServicePtr->getRXCharacteristicHandle(), params->data, bytesRead);
            }
         else {
            uint8_t SEND[15] = "Freq not allow";
            uint8_t SEND2[10] = "Try again";
            ble.updateCharacteristicValue(uartServicePtr->getRXCharacteristicHandle(), SEND , sizeof(SEND));
            
            ble.updateCharacteristicValue(uartServicePtr->getRXCharacteristicHandle(), SEND2 , sizeof(SEND2));
                }
            
       
        }
     
        
        if (s == "I")
        {        
            uint8_t SEND[20];
            sprintf((char*)SEND, "I: %.03f",Vsens);
            ble.updateCharacteristicValue(uartServicePtr->getRXCharacteristicHandle(), SEND , sizeof(SEND));
        }
        
        
        
        if (s == "V")
        {
           uint8_t SEND[20];
           sprintf((char*)SEND, "Vbuss: %.03f",Vbuss);
            ble.updateCharacteristicValue(uartServicePtr->getRXCharacteristicHandle(), SEND , sizeof(SEND));
        }
        
        
        if (s == "S")
        {
            
            if ( s2 == "R"){
                t2.reset();
                BLEDicert = 'R';
                stopp_PWM();
                AC_PWM(BLEfreq,BLEDicert);
                ble.updateCharacteristicValue(uartServicePtr->getRXCharacteristicHandle(), params->data, bytesRead);
                wait(4);
                start_PWM();
                 
                
                }
            if (s2 == "L"){
                BLEDicert = 'L';
                 stopp_PWM();
                AC_PWM(BLEfreq,BLEDicert);
                wait(4);
                start_PWM();
                ble.updateCharacteristicValue(uartServicePtr->getRXCharacteristicHandle(), params->data, bytesRead); 
                }
            //Stopp
            if(s2 == "topp"){
                runSK ='S';
                stopp_PWM();
                printf("STOPP\n");   
                ble.updateCharacteristicValue(uartServicePtr->getRXCharacteristicHandle(), params->data, bytesRead);     
            }    
            //Start
            if(s2 == "tart"&& runSK =='S'){
                runSK = 'K';
                start_PWM();
                configs = true; 
                printf("START\n");
                ble.updateCharacteristicValue(uartServicePtr->getRXCharacteristicHandle(), params->data, bytesRead);      
            }  
            else if (s2 == "tart"){
                uint8_t SEND[11] = "Its Runnig";
                ble.updateCharacteristicValue(uartServicePtr->getRXCharacteristicHandle(), SEND , sizeof(SEND));
            }
            
            if(s2 == "etup"){
                printf("SETUP\n");
                ble.updateCharacteristicValue(uartServicePtr->getRXCharacteristicHandle(), params->data, bytesRead);       
            } 
            if(s2 == "new"){
                printf("New\n");
                ble.updateCharacteristicValue(uartServicePtr->getRXCharacteristicHandle(), params->data, bytesRead);
                   
            }  
            if(s2 == "tic"){
                led1=1;
                printf("Starts\n");
                ble.updateCharacteristicValue(uartServicePtr->getRXCharacteristicHandle(), params->data, bytesRead);
            }  
            if(s2 == "tics"){
                ble.updateCharacteristicValue(uartServicePtr->getRXCharacteristicHandle(), params->data, bytesRead);
            
                   
            } 
            
            if(s2 == "ticc"){
                ble.updateCharacteristicValue(uartServicePtr->getRXCharacteristicHandle(), params->data, bytesRead);       
            }           
        
        }
        if (s == "H")
        {
             if(s2 == "elp"){

            uint8_t SEND[15] = "Enter commands";
            uint8_t SEND2[18] = "F+int change Freq";
            uint8_t SEND7[17] = "eks F50 is 50 Hz";
            uint8_t SEND3[15] = "Start to start";
            uint8_t SEND4[14] = "Stopp to stop";
            uint8_t SEND5[18] = "SR motor go right";
            uint8_t SEND6[17] = "SL motor go left";
            ble.updateCharacteristicValue(uartServicePtr->getRXCharacteristicHandle(), SEND , sizeof(SEND));
            ble.updateCharacteristicValue(uartServicePtr->getRXCharacteristicHandle(), SEND2 , sizeof(SEND2));
             ble.updateCharacteristicValue(uartServicePtr->getRXCharacteristicHandle(), SEND7 , sizeof(SEND7));
            ble.updateCharacteristicValue(uartServicePtr->getRXCharacteristicHandle(), SEND3 , sizeof(SEND3));
            ble.updateCharacteristicValue(uartServicePtr->getRXCharacteristicHandle(), SEND4 , sizeof(SEND4));
            ble.updateCharacteristicValue(uartServicePtr->getRXCharacteristicHandle(), SEND5 , sizeof(SEND5));
            ble.updateCharacteristicValue(uartServicePtr->getRXCharacteristicHandle(), SEND6 , sizeof(SEND6));
            }
            
        }
        //DEBUG("received %u bytes\n\r", bytesRead);
        
        
        
        
    }
}




void configBLE (void){
   
    PWM_AC_run();

    
    }


int main(void)
{

    //Bluethhoth 
    ble.init();
    ble.onDisconnection(disconnectionCallback);
    ble.onDisconnection(disconnectionCallback);
    ble.onDataWritten(onDataWritten);



    /* setup advertising */
    ble.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED);
    ble.setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::SHORTENED_LOCAL_NAME,
                                     (const uint8_t *)"BLE UART", sizeof("BLE UART") - 1);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_128BIT_SERVICE_IDS,
                                     (const uint8_t *)UARTServiceUUID_reversed, sizeof(UARTServiceUUID_reversed));
  
    
    ble.setAdvertisingInterval(1000); /* 1000ms; in multiples of 0.625ms. */
    ble.startAdvertising();
    //UART BLE
    UARTService uartService(ble);
    uartServicePtr = &uartService;
   
   nullstill();
   AC_PWM(BLEfreq,BLEDicert);
   
    printf("BLE STARTET \n");
    
        while (true) {
         ble.waitForEvent();
        
        
        if (Stopp == 0) { // Button is pressed
            
            stopp_PWM();
            runSK = 'S';
            printf("Butten Stopp \n");
            uint8_t SEND[7] = "STOPED";
            ble.updateCharacteristicValue(uartServicePtr->getRXCharacteristicHandle(), SEND , sizeof(SEND)); 
            
            wait(0.3);
        }
        
       //Finner gjenneomsnitt
           int Ssize;
                Ssize = sizeof(arryVsens) / sizeof(arryVsens[0]);
        
        if (intVsensMean == Ssize){
            float VsensSum = 0.0; 
            float VbussSum = 0.0; 
           int Bsize;
                Bsize = sizeof(arryVbuss) / sizeof(arryVbuss[0]);
           
           
           for (int i=1; i<Ssize; i++){
               VsensSum += arryVsens[i];
               VbussSum += arryVbuss[i];            
               }
            Vsens = VsensSum/Ssize; 
            Vsens=Vsens/1.35;//1.894;
            Vbuss = VbussSum/Ssize;
            Vbuss = Vbuss*45.45;
            
            intVsensMean=0;  
                     
            }
        else{
            
           //Ganger opp med 3.36 for å få volt
            arryVsens[intVsensMean] = AVsens.read()*3.36;
            
            arryVbuss[intVsensMean] = AVbuss.read()*3.36;
            intVsensMean++;
            }
            
          

         
    }
    
}

