/**********************************************************************
* Copyright (C) 2016 Maxim Integrated Products, Inc., All Rights Reserved.
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
**********************************************************************/


#include "mbed.h"
#include "max32630fthr.h"
#include "bmi160.h"

#define LOG(...) { printf(__VA_ARGS__); }

int main() {
    DigitalOut rLED(LED1, LED_OFF);
    DigitalOut gLED(LED2, LED_OFF);
    DigitalOut bLED(LED3, LED_OFF);

    I2C i2cBus(P5_7, P6_0);
    i2cBus.frequency(400000);
    BMI160_I2C imu(i2cBus, BMI160_I2C::I2C_ADRS_SDO_LO);
    
    I2C dataOut(P3_4, P3_5);
    dataOut.frequency(10000);

    uint32_t failures = 0;

    MAX32630FTHR pegasus(MAX32630FTHR::VIO_3V3);

    if(imu.setSensorPowerMode(BMI160::GYRO, BMI160::NORMAL) != BMI160::RTN_NO_ERROR) {
        LOG("Failed to set gyroscope power mode\n");
        failures++;
    }
    wait_ms(100);
    
    if(imu.setSensorPowerMode(BMI160::ACC, BMI160::NORMAL) != BMI160::RTN_NO_ERROR) {
        LOG("Failed to set accelerometer power mode\n");
        failures++;
    }
    wait_ms(100);

    BMI160::AccConfig accConfig;
    //example of using getSensorConfig
    if(imu.getSensorConfig(accConfig) == BMI160::RTN_NO_ERROR) {
        LOG("ACC Range = %d\n", accConfig.range);
        LOG("ACC UnderSampling = %d\n", accConfig.us);
        LOG("ACC BandWidthParam = %d\n", accConfig.bwp);
        LOG("ACC OutputDataRate = %d\n\n", accConfig.odr);
    } else {
        LOG("Failed to get accelerometer configuration\n");
        failures++;
    }
    
    //example of setting user defined configuration
    accConfig.range = BMI160::SENS_4G;
    accConfig.us = BMI160::ACC_US_OFF;
    accConfig.bwp = BMI160::ACC_BWP_2;
    accConfig.odr = BMI160::ACC_ODR_8;
    if(imu.setSensorConfig(accConfig) == BMI160::RTN_NO_ERROR) {
        LOG("ACC Range = %d\n", accConfig.range);
        LOG("ACC UnderSampling = %d\n", accConfig.us);
        LOG("ACC BandWidthParam = %d\n", accConfig.bwp);
        LOG("ACC OutputDataRate = %d\n\n", accConfig.odr);
    } else {
        LOG("Failed to set accelerometer configuration\n");
        failures++;
    }
    
    BMI160::GyroConfig gyroConfig;
    if(imu.getSensorConfig(gyroConfig) == BMI160::RTN_NO_ERROR) {
        LOG("GYRO Range = %d\n", gyroConfig.range);
        LOG("GYRO BandWidthParam = %d\n", gyroConfig.bwp);
        LOG("GYRO OutputDataRate = %d\n\n", gyroConfig.odr);
    } else {
        LOG("Failed to get gyroscope configuration\n");
        failures++;
    }
    
    wait(1.0);
    
    if(failures == 0) {
        float imuTemperature; 
        BMI160::SensorData accData;
        BMI160::SensorData gyroData;
        BMI160::SensorTime sensorTime;
        
        char buffer[256] = {0};
        
        while(1) {
            imu.getGyroAccXYZandSensorTime(accData, gyroData, sensorTime, accConfig.range, gyroConfig.range);
            imu.getTemperature(&imuTemperature);
            
            sprintf(buffer, "%d,%d,%d\n", accData.xAxis.raw, accData.yAxis.raw, accData.zAxis.raw);
            LOG(buffer);
            dataOut.write(0x8<<1, buffer, strlen(buffer) + 1);

            gLED = !gLED;
        }
    } else {
        while(1) {
            rLED = !rLED;
            wait(0.25);
        }
    }
}
