/* mbed Ping Library
 *
 *
 */


#include "IRM2121.h"
#include "mbed.h"


IRM2121::IRM2121(PinName IRM_PIN)
        : _event(IRM_PIN)
        , _timer()
        {
            //_event.rise(this,&IRM2121::_Stop );
            //_event.fall(this,&IRM2121::_Start );
            //_event.disable_irq();
            
            _Flag = false;
        } 
        
void IRM2121::_Start(void)
{
      _Flag  = true;
      _Valid = false;  // start the timere, and invalidate the current time.
      _Busy  = true;
      _timer.start();
      _Time  = _timer.read_us();      
}

void IRM2121::_Stop(void)
{
      if(_Flag == true){
        _Flag  = false;
        _Valid = true;  // When it stops, update the time
        _Busy  = false;
        _Time  = _timer.read_us()-_Time;
        //_event.rise(this, 0);
        //_event.fall(this, 0);
        _event.rise_disable(this,&IRM2121::_Stop);
        _event.fall_disable(this,&IRM2121::_Start);
      }
}

void IRM2121::Set()
{
     //_event.enable_irq();
    _event.rise(this,&IRM2121::_Stop);
    _event.fall(this,&IRM2121::_Start);
}

int IRM2121::Read()
// -1 means not valid.
{
    if(_Valid && ~_Busy) 
        return (_Time);
    else 
        return -1;
}