#include "mbed.h"
#include "CAN.h"
 
 Ticker ticker;
 
 DigitalOut led1(LED1);
 DigitalOut led2(LED2);
 DigitalOut led3(LED3);
 DigitalOut led4(LED4);
 
 LocalFileSystem local("local");
 
 // CAN_RS pin at Philips PCA82C250 can bus controller.
 // activate transceiver by pulling this pin to GND.
 // (Rise and fall slope controlled by resistor R_s)
 // (+5V result in tranceiver standby mode)
 // For further information see datasheet page 4
 DigitalOut can_Pca82c250SlopePin(p28);
  
 // second can controller on these pins. Not used here.
 CAN can2(p9, p10);
 
 // We use can on mbed pins 29(CAN_TXD) and 30(CAN_RXD).
 CAN can1(p30, p29);

/* void send1() {
     static char counter1 = 0;
     if (can1.write(CANMessage(0x200, &counter1, 1))) {
         printf("CanTx--> id: 0x200  dlc: 1  data: %x\n\r", counter1);
         counter1++;
     }
     // toggle led1 after every transmission
     led1 = !led1;
 }*/

/* void send2() {
     static char counter2 = 0;
     if (can2.write(CANMessage(0x300, &counter2, 1))) {
         printf("CanTx--> id: 0x300  dlc: 2  data: %x\n\r", counter2);
         counter2++;
     }
     // toggle led2 after every transmission
     led2 = !led2;
 }*/

 void send() {
     static char counter = 0;
     if (can2.write(CANMessage(0x300, &counter, 1))) {
         printf("CanTx--> id: 0x300  dlc: 2  data: %x\n\r", counter);
         counter++;
     }
     if (can1.write(CANMessage(0x200, &counter, 2))) {
         printf("CanTx--> id: 0x300  dlc: 2  data: %x\n\r", counter);
         counter++;
     }
     // toggle led2 after every transmission
     led2 = !led2;
 }

 int main() {
 
  FILE *test1 = fopen("/local/test1.txt", "w");
  FILE *test2 = fopen("/local/test2.txt","w");
 
  bool flag1 = false;
  bool flag2 = false;
  int i =0 ;

     // 500kbit/s
     can1.frequency(500000);
     can2.frequency(500000);
     // activate external can transceiver
     can_Pca82c250SlopePin = 0;
     // every 500ms
     ticker.attach(&send, 0.5);     
     // create message object for message reception
   //  CANMessage can_MsgRx;
        
    CANMessage can_MsgRx1;            
    CANMessage can_MsgRx2;  
 //------------------------RECEPTION--------------------------------------\\        
   while(i<10)
   {

         while (flag1!=true)
        

             // send received messages to the pc via serial line (9k6, 8n1)
                 if (can1.read(can_MsgRx1))
                {
                      led3 = !led3;
                      flag1 = true;
                }
             
        while ( flag2!=true )    
        
                 if (can2.read(can_MsgRx2))
                {
                      led4 = !led4;
                      flag2 = true;
                }
      
       
        
      
       fprintf(test1,"%d-%d-%c%c%c%c%c%c%c%c\r",can_MsgRx1.len,can_MsgRx1.id,can_MsgRx1.data[0],can_MsgRx1.data[1],can_MsgRx1.data[2],can_MsgRx1.data[3],can_MsgRx1.data[4],can_MsgRx1.data[5],can_MsgRx1.data[6],can_MsgRx1.data[7]);
       fprintf(test2,"%d-%d-%c%c%c%c%c%c%c%c\r",can_MsgRx2.len,can_MsgRx2.id,can_MsgRx2.data[0],can_MsgRx2.data[1],can_MsgRx2.data[2],can_MsgRx2.data[3],can_MsgRx2.data[4],can_MsgRx2.data[5],can_MsgRx2.data[6],can_MsgRx2.data[7]);
       flag1 = false ;
       flag2 = false ;
       i++;
    }  
    
       
       fclose(test1);
       fclose(test2);
}
