/*Control mBed LEDs via Serial Port of PC.
-->By Kailash.P.Sivanesan, Nov 5th 2010.

Use Hyperterminal (or RealTerm or your favorite terminal program) to read and write data to your mBed board.

Pressing 1 on keyboard toggles first LED.
Pressing 2 on keyboard toggles second LED.
Pressing 3 on keyboard toggles third LED.
Pressing 4 on keyboard toggles fourth LED.

Pressing any other key on keyboard turns all LEDs off.

For info on Serial Port settings, driver etc:
http://mbed.org/handbook/Windows-serial-configuration
http://mbed.org/handbook/Serial
*/

#include "mbed.h"

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

Serial pc(p9, p10);

void DecodeInput(char input);
void OffAllLeds(void);

int main() {
    char input = 'Z';
    pc.printf("Looking for Serial Input...\r\n");              //Inform user that i am alive
    
    while(1){
        input = pc.getc();                                     //Get user input
        pc.printf("Received: %c\r\n", input);                   
        DecodeInput(input);                                    //Take action based on user input
    }
}

void DecodeInput(char input)
{
    switch(input)
    {
        case '1':   myled1 = !myled1.read();
                    break;
        case '2':   myled2 = !myled2.read();
                    break;
        case '3':   myled3 = !myled3.read();
                    break;
        case '4':   myled4 = !myled4.read();
                    break;
        default:    OffAllLeds();
                    break;        
    }
}

void OffAllLeds()
{
    myled1 = 0;
    myled2 = 0;
    myled3 = 0;
    myled4 = 0;
    
    return;
}
