#include "console.h"
#include <stdio.h>
Serial mc(p13, p14);

#define ETATACC_ENTRY 1  // Etat Acceuil
#define ETATACC_DO 2 
#define ETATMV_ENTRY 3 // Etat MenuVitesse
#define ETATMV_DO 4    
#define ETATVC1_ENTRY 5    // Etat Menu Vitesse CanOpen 01
#define ETATVC1_DO 6
#define ETATCV1_ENTRY 7   // Etat Configurer Vitesse CanOpen 01
#define ETATCV1_DO 8
#define ETATVIC1_ENTRY 9  // Etat Vitesse Actuelle CanOpen 01
#define ETATVIC1_DO 10
#define ETATVC2_ENTRY 11  // Etat Menu Vitesse CanOpen 02
#define ETATVC2_DO 12
#define ETATCV2_ENTRY 13    // Etat Configurer Vitesse CanOpen 02
#define ETATCV2_DO 14
#define ETATVIC2_ENTRY 15   // Etat Vitesse Actuelle CanOpen 02
#define ETATVIC2_DO 16
#define ETATCFIP_ENTRY 17  // Etat Menu Configurer IP
#define ETATCFIP_DO 18
#define ETATAD_ENTRY 19   // Etat Adresse Configurer IP
#define ETATAD_DO 20
#define ETATMSQ_ENTRY 21   // Etat Masque Configurer Masque
#define ETATMSQ_DO 22
#define ETATCFACT_ENTRY 23   // Etat Config Actuelle configurer IP
#define ETATCFACT_DO 24


void tconsole :: RecevoirChaine(char* Tableau)
{
    bool arr = false ;
    char car ;
    int i = 0 ;
    while (arr == false)
    {
        
        car = mc.getc(); 
        
        if( car == ' ')
        {
            arr = true;   
        }
        else
        {
            Tableau[i] = car ;
            i++;
        }
    }
}


void tconsole :: Menu()
{

  mc.baud(9600);
  int etat ;
  char choix ;
mc.printf("debut");
if(        
        etat = ETATACC_ENTRY ;


switch(etat) 
{ 
///////////////////////////////////////////////////// Etat Accueil///////////////////////////////////////////////////////////////////////
case ETATACC_ENTRY : 
 
    mc.printf("\r\n\r ACCUEIL\r\n\r");
    mc.printf("1 - Vitesse\r\n\r");
    mc.printf("2 - Configuration\r\n\r");
    etat = ETATACC_DO ;
    break;     

case ETATACC_DO :
    if(mc.readable() == 1)
    {
    choix = mc.getc();
    if(choix == '1') etat = ETATMV_ENTRY ;
    else if(choix == '2') etat = ETATCFIP_ENTRY ;
    }  
    break;
    
/////////////////////////////////////////////// Etat MenuVitesse//////////////////////////////////////////////////////////////////////////
case ETATMV_ENTRY :        

     mc.printf("\r\n\r VITESSE\r\n\r");
     mc.printf("1 - Vitesse Bus Can 1\r\n\r");
     mc.printf("2 - Vitesse Bus Can 2\r\n\r");
     mc.printf("3 - Precedent");
     etat = ETATMV_DO ;
     break;

case ETATMV_DO : 
     if(mc.readable() == 1)
     {    
     choix = mc.getc();
     if(choix == '1') etat =ETATVC1_ENTRY ;
     else if(choix == '2') etat = ETATVC2_ENTRY ;
     else if(choix == '3') etat = ETATACC_ENTRY ;
     }
     break;

   
//////////////////////////////////////////////// Etat Menu Vitesse CanOpen 01/////////////////////////////////////////////////////////////////
 
case ETATVC1_ENTRY : 
     mc.printf("\r\n\rVITESSE BUS CAN 1\r\n\r");
     mc.printf("1 - Changer Vitesse\r\n\r");
     mc.printf("2 - Vitesse Actuel\r\n\r");
     mc.printf("3 - Precedent\r\n\r");
     etat = ETATVC1_DO ;
     break; 
    
case ETATVC1_DO :   
    if(mc.readable() == 1)
    {     
    choix = mc.getc();
    if(choix == '1') etat = ETATCV1_ENTRY ;
    else if(choix == '2') etat = ETATVIC1_ENTRY ;
    else if(choix == '3') etat = ETATMV_ENTRY ;
    }
    break;
 
////////////////////////////////////////////////////////// Etat Configurer Vitesse CanOpen 01 /////////////////////////////////////////////////////
 
case ETATCV1_ENTRY :      
     mc.printf("\r\n\r Changer Vitesse\r\n\r");
     mc.printf("Choisir une nouvelle vitesse pour bus can 1\r\n\r");
     mc.printf(" 1 - 1 Mbit/s\r\n\r 2 - 500 Kbit/s\r\n\r 3 - 100 Kbit/s\r\n\r 4 - 20 Kbit/s\r\n\r");
     mc.printf("0 - Precedent\r\n\r");
     etat = ETATCV1_DO ;
     break;

case ETATCV1_DO :
     if(mc.readable() == 1)
    {       
     choix = mc.getc();
     if(choix == '1')
     {
       V1 = 1000000 ;
       mc.printf("Vitesse = 1000000 (1 Mbit/s)");
       etat = ETATVC1_ENTRY ;
     }           
     
     if(choix == '2')
     { 
       V1 = 500000 ;
       mc.printf("Vitesse = 500000 (500 Kbit/s)");
       etat = ETATVC1_ENTRY ;
     }          
    
     if(choix == '3')
     {
       V1 = 100000 ;
       mc.printf("Vitesse = 100000 (100 Kbit/s)");
       etat = ETATVC1_ENTRY ;
     }
    
     if(choix == '4')
     { 
       V1 = 20000 ;
       mc.printf("Vitesse = 20000 (20 Kbit/s)");
       etat = ETATVC1_ENTRY ;
     }
      
     if(choix == '0')
     {  
       etat = ETATVC1_ENTRY ;
     }
  }                                                      
     break;         
   

/////////////////////////////////////////////////////// Etat Vitesse Actuelle CanOpen 01/////////////////////////////////////////////////////////////////

  
   case ETATVIC1_ENTRY :
     mc.printf("\r\n\rVitesse Actuel\r\n\r");
     mc.printf("Vitesse Actuel = %d\r\n\r", V1);
     mc.printf("0 - Precedent\r\n\r");
     etat = ETATVIC1_DO ;
     break;
     
     
  case ETATVIC1_DO :   
    if(mc.readable() == 1)
    {
     choix = mc.getc();
     if(choix == '0') etat = ETATVC1_ENTRY ;
    } 
     break;
    
 //////////////////////////////////// Etat Menu Vitesse CanOpen 02/////////////////////////////////////////////////////

   
case ETATVC2_ENTRY :     
     mc.printf("\r\n\rVITESSE BUS CAN 2\r\n\r");
     mc.printf("1 - Changer Vitesse\r\n\r");
     mc.printf("2 - Vitesse Actuel\r\n\r");
     mc.printf("3 - Precedent\r\n\r");
     etat = ETATVC2_DO ;
     break;
     
case ETATVC2_DO : 
    if(mc.readable() == 1)
    {    
    choix = mc.getc();
    if(choix == '1') etat = ETATCV2_ENTRY ;
    else if(choix == '2') etat = ETATVIC2_ENTRY ;
    else if(choix == '3') etat = ETATMV_ENTRY ;
    }
    break;
               
////////////////////////////////////////// Etat Configurer Vitesse CanOpen 02//////////////////////////////////////////
 
  case ETATCV2_ENTRY :  
  
     mc.printf("\r\n\rChanger Vitesse\r\n\r");
     mc.printf("Choisir une nouvelle vitesse pour bus can 2\n\r\n\r");
     mc.printf(" 1 - 1 Mbit/s\r\n\r 2 - 500 Kbit/s\r\n\r 3 - 100 Kbit/s\r\n\r 4 - 20 Kbit/s\r\n\r");
     mc.printf("0 - Precedent\r\n\r");
     etat = ETATCV2_DO ;
     break;
     
 case ETATCV2_DO :  
  if(mc.readable() == 1)
    {
     choix = mc.getc();
     if(choix == '1')
     {
       V2 = 1000000 ;
       mc.printf("Vitesse = 1000000 (1 Mbit/s)");
       etat = ETATVC2_ENTRY ;
     }           
     
     if(choix == '2')
     { 
       V2 = 500000 ;
       mc.printf("Vitesse = 500000 (500 Kbit/s)");
       etat = ETATVC2_ENTRY ;
     }          
    
     if(choix == '3')
     {
       V2 = 100000 ;
       mc.printf("Vitesse = 100000 (100 Kbit/s)");
       etat = ETATVC2_ENTRY ;
     }
    
     if(choix == '4')
     { 
       V2 = 20000 ;
       mc.printf("Vitesse = 20000 (20 Kbit/s)");
       etat = ETATVC2_ENTRY ;
     }
      
     if(choix == '0')
     {  
       etat = ETATVC2_ENTRY ;
     }
   }                                                     
     break;          
   
   

////////////////////////////////////////// Etat Vitesse Actuelle CanOpen 02///////////////////////////////////////////////////////////////
  
   case ETATVIC2_ENTRY : 
     mc.printf("Vitesse Actuel\r\n\r");
     mc.printf("Vitesse Actuel = %d\r\n\r", V2);
     mc.printf("0 - Precedent\r\n\r");
     etat = ETATVIC2_DO ;
     break;
  
  case ETATVIC2_DO :
     if(mc.readable() == 1)
     {
     choix = mc.getc();
     if(choix == '0') etat = ETATVC2_ENTRY ;
     }
     break;
    
   
///////////////////////////////////////////////////////////// Etat Menu Configurer IP//////////////////////////////////////////////////////////////////
   
   case ETATCFIP_ENTRY :        
   
     mc.printf("\r\n\rCONFIGURER\r\n\r");
     mc.printf("1 - Adresse\r\n\r");
     mc.printf("2 - Masque \r\n\r");
     mc.printf("3 - Configuration Actuelle\r\n\r");
     mc.printf("4 - Precedent\r\n\r");
     etat = ETATCFIP_DO ;
     break;
     
   case ETATCFIP_DO :
   
    if(mc.readable() == 1)
    {
    choix = mc.getc();
    if (choix == '1') etat = ETATAD_ENTRY ;
    else if (choix == '2') etat = ETATMSQ_ENTRY ;
    else if (choix == '3') etat = ETATCFACT_ENTRY ;
    else if (choix == '4') etat = ETATACC_ENTRY ;
    }
    break;

    
//////////////////////////////////////////////////////////// Etat Adresse Configurer IP ///////////////////////////////////////////////////////
    
    case ETATAD_ENTRY :     
       mc.printf("\r\n\rNouvelle IP\r\n\r");
       mc.printf("Ip : ");
       etat = ETATAD_DO ;
       break;
       
    case ETATAD_DO :    
       RecevoirChaine(IP);
       etat = ETATCFIP_ENTRY ;
       break;      
      
/////////////////////////////////////////////////////// Etat Masque Configurer Masque /////////////////////////////////////////////////////////////
    
    case ETATMSQ_ENTRY :          
       mc.printf("\r\n\rNouveau Masque\r\n\r");
       mc.printf("Masque : ");
       etat = ETATMSQ_DO ;
       break;
       
    case ETATMSQ_DO :
       RecevoirChaine(Masque);       
       etat = ETATCFIP_ENTRY ;
       break;
    
///////////////////////////////////////////////// Etat Config Actuelle configurer IP////////////////////////////////////////////////////////////////////
    
    
    case ETATCFACT_ENTRY :
         mc.printf ("\r\n\rConfiguration Actuelle\r\n\r");
         mc.printf ("Adresse : %s\r\n\r",IP);
         mc.printf ("Masque : %s\r\n\r",Masque);
         mc.printf ("0 - Precedent\r\n\r");
         etat = ETATCFACT_DO ;
         break;
        
    case ETATCFACT_DO :        
        choix = mc.getc();
        if(choix == '0') etat = ETATCFIP_ENTRY ;
        break;
        
        
}
}
