#include "mbed.h"
#include "BMP085.h"
#include "string.h"

BMP085 bmp085(p9, p10);

DigitalOut myled(LED1);
DigitalOut myled4(LED4);
Serial pc(USBTX, USBRX);

LocalFileSystem local("local");

int main() {
    float p, t;
    int ii=0;
    char pname[12],stval[6];
    DIR *d = opendir("/local");               // Opens the root directory of the local file system
    struct dirent *pdir;
    int indice=1;
    while((pdir = readdir(d)) != NULL) {         // Print the names of the files in the local file system
       pc.printf("%u  %s\r",indice, pdir->d_name);
      if(strstr(pdir->d_name,"OUT")== pdir->d_name) {
           indice++;
      }
    }
    closedir(d);
    strcpy(pname,"/local/out");
    sprintf(stval,"%02u",indice);
    strcat(pname,stval);
    strcat(pname,".txt");
    
    FILE *fp = fopen(pname, "w");  // Open "out.txt" on the local file system for writing
    myled4=0;
    while(1) {
        myled = 1;

        bmp085.update();
        p = bmp085.get_pressure();
        t = bmp085.get_temperature();
//        if(t>24.0){
//            myled4=1;    
//        }else{
//            myled4=0;
//        }
        pc.printf("p:%6.2f hPa / t:%6.2f C\r", p, t);
        
        if(ii<60){
           ii=ii+1;
           fprintf(fp,"p:%6.2f hPa / t:%6.2f C\r", p, t);
        }else{
            fclose(fp);
            myled4=1;    
        }    

        myled = 0;
        wait(0.5);
    }
}
