/*
****************************************************
Frequency is measured by interrupts.

Wiring: TSL230       mBed
         p1(s0)      H (p39)
         p2(s1)      L (p1)
         p7(s2)      H (p39)
         p8(s3)      H (p39)
         p6(out)     p11
les pattes du TSL230 qui reste :
p3(OE), p4(GND) tied to ground. p5(Vcc) tied to 3V3.

Author: Samir Bouaziz. october 2011.
*********************(******************************
*/


#include "mbed.h"
#include "math.h"


Serial pc(USBTX, USBRX);
InterruptIn in(p11);
Timer t,t2;

float period = 0; // This is the period between interrupts in microseconds
float freq = 0;
volatile int demiper,n=0,per;

void itup() {
   switch(n){
      case 0 :
               t.start();
               n++;
               break;
     // case 1 : 
      case 10: t.stop();
               per=t.read_us();
               n=0;
               t.reset();
               break;
      default : n++;
                break;
    }
}

void itdown() {
    demiper=t.read_us();
    t.stop();
}


int main() {
float mes;
//    in.mode(PullUp); // Set the pin to Pull Down mode.
    in.rise(&itup);  // Set up the interrupt for rising edge
//    in.fall(&itdown);  // Set up the interrupt for rising edge
    while (1) {
        wait(1);
        //freq= 100000.0/((float)per);
        mes=(10000./((float)per))/0.0069;
        pc.printf("%f %f\r\n",mes,10000000./((float)per));

    }
}



