#include "mbed.h"
#include "CAN.h"

LocalFileSystem local("local");

Ticker ticker;

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);


// CAN_RS pin at Philips PCA82C250 can bus controller.
// activate transceiver by pulling this pin to GND.
// (Rise and fall slope controlled by resistor R_s)
// (+5V result in tranceiver standby mode)
// For further information see datasheet page 4
//DigitalOut can_Pca82c250SlopePin(p28);

// second can controller on these pins. Not used here.
// CAN can1(p9, p10);

// We use can on mbed pins 29(CAN_TXD) and 30(CAN_RXD).
CAN can2(p30, p29);
Serial pc(p13,p14);

FILE *fp ;
unsigned int flag=0;

void send() {
    static char counter = 0;
    if (can2.write(CANMessage(0x200, &counter, 1))) {
      
       //  LPC_CAN2->CMR &= 0xEF; // stop back Tx
       pc.printf("CanTx--> id: 0x200  dlc: 1  data: %x\n\r", counter);
        counter++;
    }
    // toggle led1 after every transmission
    led1 = !led1;
    
}

int main() {
    // 500kbit/s
    can2.frequency(500000);
    // every 500ms
    ticker.attach(&send, 0.5);
    /// create message object for message reception
    CANMessage can_MsgRx;
    pc.baud(38400);
    pc.format(8,Serial::None,1);
    while (1) {
        // send received messages to the pc via serial line (9k6, 8n1)
        if (can2.read(can_MsgRx)) {
           
            led3= can_MsgRx.data[0]&0x01;
            led4= (can_MsgRx.data[0]&0x02)>>1;
            // any incoming message: toggle led2
            pc.printf("Receive  %3x  %2u\n\r",can_MsgRx.id,can_MsgRx.len);  
            led2 = !led2;
        }
    }
}