#include "mbed.h"
I2C i2c(p28, p27);
Serial pc(USBTX, USBRX); // tx, rx
// Code &#65533; respecter pour FS
//Write this offset to trigger an ECAM Control Panel button press.
// The value is 1 for ENG, 2 for BLEED, 3 for PRESS, 4 for ELEC, 5 for HYD,
// 6 for FUEL, 7 for APU, 8 for COND, 9 for DOOR, 10 for WHEEL, 11 fro FCTL,
// 12 for STS, 16 for TO CONFIG, 17 for CLR, 18 for RCL.
// Is set to 0 when the action is done.

// correspondance touche-bit sur les 8575
//ADDR2 :  X HYD X ALL X CLRD X X  INT_UPPER INT_LOWER XX X EMER X FUEL
//            5    23      17          20        21         22     6
//ADDR1 :  X ELEC X Wheel X RCL X STS XXXX X XX F/CTL
//            4      10     18    12             11
//ADDR0 :  X Cond X ENG X APU X CLRG X TOCONFIG X Press X Door X Bleed
//            8     1      7     17      16        3       9      2 
const unsigned LEDt[12]={0x0dfff,0x0fffd,0x0ffdf,0x17fff,
                         0x27fff,0x2fffd,0x0f7ff,0x07fff,
                         0x0fff7,0x1dfff,0x1fffd,0x1fdff};
const char mess[23][10]={"ENG","BLEED","PRESS","ELEC","HYD","FUEL","APU",
                         "COND","DOOR","WHEEL","FCTL","STS"," "," "," ","TOCONFIG",
                         "CLR","RCL"," ","INT_UP","INT_LOW","EMER","ALL"};
                         
const unsigned short lutbutt01[18]={0xefff,0xfffe,0xffef,0x7fff,
                                    0,0,0xfbff,0xbfff,
                                    0xfffb,0xdfff,0xfffd,0xfdff,
                                    0,0,0,0xffbf,0xfeff,0xf7ff};
                                    
unsigned short addrt[3] = {0x40,0x42,0x44}; // define the I2C Address write pcf1
unsigned short valt[3],oldt[3]={0xffff,0xffff,0xffff};                                    
                                    
unsigned char decod_butt(unsigned short *v){ //tableau 3 cases
     unsigned short loc=(v[0]&0x5555)| ((v[1]<<1)&0xAAAA);
     unsigned short iloc;
     
     if(loc!=(unsigned short)0xffff){
            iloc=0;
            while((iloc<18)&(loc!=lutbutt01[iloc])){
                iloc++;
            }
            if(iloc<18){
                return iloc+1;
            }
            return 255;
     }
     loc=v[2]&0x54C5;
     if(loc !=0x5405){
        switch(loc){
            case 0x14C5: return 5;
            case 0x44C5: return 23;
            case 0x50C5: return 17;
            case 0x54c1: return 22;
            case 0x54C4: return 6;
                    
            default :
                      break;
        }
     }
     // reste &#65533; traiter les 2 boutons rotatifs .... v[2]&0x00c0
     return 255;
}

//unsigned short int tt[8]={0xFFFd,0xFFF7,0xFFdF,0xFF7F,0xFdFF,0xF7FF,0xDFFF,0x7FFF};
void read_ecam(unsigned short *v){
      unsigned char cmd[2];
      oldt[2]=v[2];
      i2c.read(addrt[0]+1, (char *)cmd, 2);
      v[0]=cmd[0]*256u+(unsigned short)cmd[1];
      i2c.read(addrt[1]+1, (char *)cmd, 2);
      v[1]=cmd[0]*256u+(unsigned short)cmd[1];
      i2c.read(addrt[2]+1, (char *)cmd, 2);
      v[2]=cmd[0]*256u+(unsigned short)cmd[1];
}

int main() {
    unsigned constffff=0xffff;
    unsigned short i=0,j=0xFFFF; 
     char tmp[2]={0x02,0xE0};
    unsigned short state=0,touche=0;
    unsigned short v2=0,v3=0;
     pc.printf("COUCOU1\n");
     // initaliser les 8575  1 recessif
    i2c.write(addrt[0],(char *)&j,2); 
    i2c.write(addrt[1],(char *)&j,2); 
    i2c.write(addrt[2],(char *)&j,2); 
   // initialiser les convertisseurs des potentiometres
    i2c.write(0xA2,(char*)tmp,2);
    wait(0.001);
    i2c.write(0xA4,(char*)tmp,2);
  
    while (1) {
      // utilis pour lire les potentiometres
          tmp[0]=0x00;
          i2c.write(0xA2,tmp,1);
          wait(0.0001);
          i2c.read(0xA3,tmp,2);
          v2= tmp[0]&0x0F;
          v2= (v2<<6)| (tmp[1]>>2)&0x3F;
          tmp[0]=0x00;
          i2c.write(0xA4,tmp,1);
          i2c.read(0xA5,tmp,2);
          v3= tmp[0]&0x0F;
          v3= (v3<<6)| (tmp[1]>>2)&0x3F;
          // Affichage des potentiometres
          printf("%5u    %5u\n\r",v2,v3);
           wait(0.1);
           // Lecture des bouton de l'ECAM
           read_ecam(valt);
           i=decod_butt(valt);
           //automate de gestion de l'appui des touches
           if(i<24){
                if(state==0){                        
                        state=1;
                        touche=i;
                }
           }else{
                state=0;
           }
           //renvoi du nom de la touche et de son code
           //si touche=0 alors pas de touche appuye
           if(touche>0){
                pc.printf("X %s %2u\n\r",mess[touche-1],(unsigned) touche);
                if(touche<13){
                    j=LEDt[touche-1]&0xffff;
                    tmp[0]= j>>8;
                    tmp[1]= j&0xff;
                    j=addrt[LEDt[touche-1]>>16];
                    i2c.write(addrt[0],(char *)&constffff,2); 
                    i2c.write(addrt[1],(char *)&constffff,2); 
                    i2c.write(addrt[2],(char *)&constffff,2); 
                    i2c.write(j,tmp,2);
                }
                touche=0;
           }
    }
}



