#include "mbed.h"

// We use can on mbed pins 29(CAN_TXD) and 30(CAN_RXD).
CAN can2(p30, p29);
Serial pc(USBTX, USBRX); // tx, rx


// chaque mot 16 bits : (CANnum << 13)| (ID );
// CANnum : CAN1 ou CAN2
// ID sur 11 bits
#define CANNUM_1 0
#define CANNUM_2 1
//********* MAcro pour insertion d'ientifiant à accepter ********************************
#define MCANSET(NUMCAN,IDCAN) (((unsigned)NUMCAN << 13)| ((unsigned)IDCAN&0x7FF ) | (1<<11))

// ident par ordre croissant
// ************** Exemple de table d'identifiants à trier par ordre croissant ***********
//***************************************************************************************
unsigned short tableAM[]={MCANSET(CANNUM_2,0x2F0),
                          MCANSET(CANNUM_2,0x2F8),
                          MCANSET(CANNUM_2,0x300)};
#define nb_AM 3

//***************************************************************************************
//---- Fonction d'insertion d'une table d'identifiant à accepter dans le
//---- filtrage matériel du CAN
//***************************************************************************************
void init_AF(unsigned short *t,unsigned n )
{
uint32_t address = 0;//adresse debut table des mask sur le CAN
unsigned i;
long maskl;

//off mode
   LPC_CANAF->AFMR = 0x00000001;
// Set explicit standard Frame
   LPC_CANAF->SFF_sa = address;// word 1
     
     for(i=0;i<n;i+=2){
                    maskl=(unsigned)t[i]<<16;
                    if(i+1<n) {
                            maskl=maskl | (unsigned)t[i+1];
                    }else{
                          maskl=maskl | 0xFFFF ;
                    }
                    LPC_CANAF_RAM->mask[i/2]=maskl;
                    address+=4;//add 4 bytes (1 long word) to point to none used word.

     }
// Set group standard Frame
   LPC_CANAF->SFF_GRP_sa = address;
   
// Set explicit extended Frame
   LPC_CANAF->EFF_sa = address;
// Set group extended Frame
   LPC_CANAF->EFF_GRP_sa = address;
// Set End of Table  
   LPC_CANAF->ENDofTable = address;
// All have ENDofTable address means are not used.
//normal mode
   LPC_CANAF->AFMR = 0x00000000;
   return;
}

// ISR to read frame but don't work beacause no interrupts
CANMessage can_MsgRx;


// Main program
//******************************* exemple utilisation filtrage CAN
int main() {
    can2.frequency(1000000);
   // Prepare MASK
    init_AF(tableAM,3);   // je filtre par rapport à la table donnée

    while (1) {

       if(can2.read(can_MsgRx)){
                 pc.printf("REC %x\n\r",can_MsgRx.id);
       }
    }
}
