//---------------------------------------------------------------------------------------------
#include "TList.h"
//---------------------------------------------------------------------------------------------
//#define internaldebug // send debug messages to USB Serial port (9600,1,N)
//---------------------------------------------------------------------------------------------
uint8_t ListCount; // Global TList counter
//---------------------------------------------------------------------------------------------
TList *pListFirst;
TList *pListLast;
//---------------------------------------------------------------------------------------------
// Main TList demo code
//---------------------------------------------------------------------------------------------
/*
  // temporary TList object
  TList *pListPointer;
  
  pListPointer = SetListNextObject();
  TObjectStep *pobjectstep = new TObjectStep(1000, 100, 0);
  pListPointer->cmdtype = 0x01;
  pListPointer->cmdobject = (TObjectStep*)pobjectstep;
 
  pListPointer = SetListNextObject();  
  TObjectWait *pobjectwait = new TObjectWait(750);
  pListPointer->cmdtype = 0x04;
  pListPointer->cmdobject = (TObjectWait*)pobjectwait;  
  
  pListPointer = SetListNextObject();
  TObjectStep *pobjectstep1 = new TObjectStep(2500, 150, 1);
  pListPointer->cmdtype = 0x01;
  pListPointer->cmdobject = (TObjectStep*)pobjectstep1;

  pListPointer = SetListNextObject();  
  TObjectWait *pobjectwait2 = new TObjectWait(225);
  pListPointer->cmdtype = 0x04;
  pListPointer->cmdobject = (TObjectWait*)pobjectwait2;    
  
  #ifdef internaldebug  
    // set pListPointer to the first object of the list
    pListPointer = GetListFirstObject();
    TObjectStep *ptemp = static_cast<TObjectStep*>(pListPointer->cmdobject);  
    printf("ObjectsStep(%d) %ld|%ld|%d\r\n",ptemp->typecode,ptemp->nsteps, ptemp->deltatime, ptemp->direction);
   
    pListPointer = pListPointer->nextobject;
    TObjectWait *ptemp2 = static_cast<TObjectWait*>(pListPointer->cmdobject);  
    printf("ObjectsWait(%d) %ld\r\n",ptemp2->typecode,ptemp2->waittime);   
    
    pListPointer = pListPointer->nextobject;
    ptemp = static_cast<TObjectStep*>(pListPointer->cmdobject);  
    printf("ObjectsStep(%d) %ld|%ld|%d\r\n",ptemp->typecode,ptemp->nsteps, ptemp->deltatime, ptemp->direction);    
    
    pListPointer = pListPointer->nextobject;
    TObjectWait *ptemp3 = static_cast<TObjectWait*>(pListPointer->cmdobject);  
    printf("ObjectsWait(%d) %ld\r\n",ptemp3->typecode,ptemp3->waittime);               
  #endif
  
  printf("ListCount=%d\r\n",GetListCount());

  // deleting list elements and internal objects
  while(DeleteListFirstObject() != 0);
  
  printf("ListCount=%d\r\n",GetListCount());
*/
//---------------------------------------------------------------------------------------------
// Global helper function
//---------------------------------------------------------------------------------------------
uint8_t GetListCount()
{
  return ListCount;
}
//---------------------------------------------------------------------------------------------
TList *GetListFirstObject()
{
  return pListFirst;
}
//---------------------------------------------------------------------------------------------
uint8_t DeleteListFirstObject()
{
  // verify if First Object is NULL
  if(pListFirst == NULL)
    return 0; //nothing to delete
  
  TList *ptemp = pListFirst->nextobject;
  if(ptemp == NULL) // first object doesn't link with other objects (unique)
  {
    #ifdef internaldebug      
        printf("Deleting Unique Object\r\n");
    #endif    

    // removes inner object first
    delete pListFirst->cmdobject;
    pListFirst->cmdobject = NULL;
    
    #ifdef internaldebug      
        printf("->removing inner object\r\n");
    #endif    
    
    // removes the outter list object
    delete pListFirst;
    pListFirst = NULL;
    pListLast = NULL;

    #ifdef internaldebug      
        printf("->removing outter object\r\n");
    #endif    
    
    // no more objects - resets the list counter
    ListCount = 0;
    
    #ifdef internaldebug      
        printf("->reseting Listcount\r\n");
    #endif    
    
  }
  else
  {
    #ifdef internaldebug      
        printf("Deleting first object of List[%d]\r\n",ListCount);
    #endif    

    // removes inner object first
    delete pListFirst->cmdobject;
    pListFirst->cmdobject = NULL;
    
    #ifdef internaldebug      
        printf("->removing inner object\r\n");
    #endif    
    
    // removes the outter list object
    delete pListFirst;
    pListFirst = NULL;
    
    #ifdef internaldebug      
        printf("->removing outter object\r\n");
    #endif    
    
    // sets the new header object
    pListFirst = ptemp; 
    
    #ifdef internaldebug      
        printf("->Setting new header object\r\n");
    #endif    
    
    // decreases list counter
    ListCount -= 1;
    
    #ifdef internaldebug      
        printf("->Setting ListCount new value = %d\r\n",ListCount);
    #endif    
    
  }
  return 1;
}
//---------------------------------------------------------------------------------------------
TList *SetListNextObject()
{  
  if(ListCount == 0)
  {
    // List is empty - initialize list
    pListFirst = new TList;
    pListLast = pListFirst;
    pListFirst->nextobject = NULL;    
    
    ListCount++;
  }
  else
  {
    // list not empty, adds new object to the list and point the 'nextobject' 
    // from previous object to the recently created object
    TList *ptemp = new TList;
    ptemp->nextobject = NULL;
    
    pListLast->nextobject = ptemp;
    
    pListLast = ptemp;
    
    ListCount++;
  }
  
  return pListLast;
}  
//---------------------------------------------------------------------------------------------