//---------------------------------------------------------------------------------------------
// Class to interface Pololu A4983 Stepper Motor Driver
// http://www.coolcomponents.co.uk/catalog/product_info.php?products_id=358&currency=EUR
// https://www.pololu.com/file/download/a4983_DMOS_microstepping_driver_with_translator.pdf?file_id=0J199
//---------------------------------------------------------------------------------------------
class A4983
{
  //-------------------------------------------------------------------------------------------
  private:
  //-------------------------------------------------------------------------------------------
  
  //-------------------------------------------------------------------------------------------
  public:
  //-------------------------------------------------------------------------------------------
  uint8_t  f_motor_enable;             // flag to Enable/Disable Step Motor, 0 => Disable, 1 => Enable
  uint8_t  f_motor_direction;          // flag for the Step Motor direction, 0 => Normal, 1 => Inverted
  float    k_delay;                    // delay constant in seconds (Step Motor Speed) [0.0001;0.000025]
  //-------------------------------------------------------------------------------------------
  A4983();

  void adjust_microstepping_mode(uint8_t factor);
  void singlestep();
  void sleep(bool value);
  void looprun();
  void loopstart();
  void loopstop();
};
//---------------------------------------------------------------------------------------------