//---------------------------------------------------------------------------------------------
#include "mbed.h"
#include "A4983.h"
//---------------------------------------------------------------------------------------------
// Pins configuration
//---------------------------------------------------------------------------------------------
//LEDs port definition on mbed
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

//ports connected to pololu driver board = straightforward connection of one side of mbed
DigitalOut Dir(p23); //direction of movement
DigitalOut Step(p24); //make one step at rising edge
DigitalOut nSleep(p25); // be HIGH to make it work
DigitalOut nReset(p26); // be HIGH to make it work
DigitalOut MS3(p19); //microstep mode selectors
DigitalOut MS2(p18);
DigitalOut MS1(p17);
DigitalOut nEnable(p27);// be LOW to make it work

#define HIGH 1
#define LOW 0
#define ON 1
#define OFF 0
#define Clockwise LOW
#define CounterClockwise HIGH

//which mode of driver to be used. This is now 1/16 stepping.
#define Factor  16
//---------------------------------------------------------------------------------------------
// USB serial port setup - debug messages
//---------------------------------------------------------------------------------------------
Serial pc(USBTX, USBRX); // tx, rx  
//---------------------------------------------------------------------------------------------  

//---------------------------------------------------------------------------------------------  
// constructor
//---------------------------------------------------------------------------------------------
A4983::A4983()
{
  //set communication speed
  pc.baud(115200);
  //test to see if comm is working
  printf("\r\nInitialize MBED Serial Port!\r\n");
  
  myled1 = 0;
  myled2 = 0;
  myled3 = 0;
  myled4 = 0;

  //-------------------------------------------------------------------------------------------
  // adjust microstepping mode
  adjust_microstepping_mode(16);

  // initialisation of power stage
  Dir = CounterClockwise;
  Step = LOW;
  nSleep = HIGH;
  nEnable = HIGH;
  nReset = LOW;
  myled1 = 1;
  myled2 = 0;
  myled3 = 0;
  myled4 = 0;

  wait(0.5);

  nReset = HIGH;
  myled1 = 0;
  myled2 = 1;
  myled3 = 0;
  myled4 = 0;

  wait(0.5);

  nEnable = LOW;
  myled1 = 1;
  myled2 = 1;
  myled3 = 0;
  myled4 = 0;

  wait(0.5);

  Step = HIGH;
  myled1 = 0;
  myled2 = 0;
  myled3 = 1;
  myled4 = 0;

  wait(0.5);

  Step = LOW;
  myled1 = 1;
  myled2 = 0;
  myled3 = 1;
  myled4 = 0;

  wait(0.5);
  //-------------------------------------------------------------------------------------------
 
  f_motor_enable = 0;    // flag to Enable/Disable Step Motor, 0 => Disable, 1 => Enable
  f_motor_direction = 0; // flag for the Step Motor direction, 0 => Normal, 1 => Inverted
  k_delay = 0.001;       // delay constant in seconds (Step Motor Speed)
}
//---------------------------------------------------------------------------------------------
void A4983::adjust_microstepping_mode(uint8_t factor)
{
  if(factor==1)
  {
    MS1 = LOW;
    MS2 = LOW;
    MS3 = LOW;  // 1/1
  }
  else if(factor==2)
  {
    MS1 = HIGH;
    MS2 = LOW;
    MS3 = LOW;  // 1/2
  }    
  else if(factor==4)
  {
    MS1 = LOW;
    MS2 = HIGH;
    MS3 = LOW;  // 1/4
  }
  else if(factor==8)
  { 
    MS1 = HIGH;
    MS2 = HIGH;
    MS3 = LOW;  // 1/8
  }
  else if(factor==16)
  {
    MS1 = HIGH;
    MS2 = HIGH;
    MS3 = HIGH; // 1/16
  }
}
//---------------------------------------------------------------------------------------------
// Step function
//---------------------------------------------------------------------------------------------
void A4983::singlestep()
{
  if(Dir != f_motor_direction)
    Dir = f_motor_direction;
       
  Step = HIGH;
  wait(k_delay/2);

  Step = LOW;
  wait(k_delay/2);
}
//---------------------------------------------------------------------------------------------
// Release Motor Command
//---------------------------------------------------------------------------------------------
void A4983::sleep(bool value)
{
  if(value == true)
  {
    //nEnable = LOW;
    nSleep = LOW;
  }
  else
  {
    //nEnable = HIGH;
    nSleep = HIGH; 
  }
}
//---------------------------------------------------------------------------------------------
// check if f_motor_enable is true and call singlestep() - loop mode
//---------------------------------------------------------------------------------------------
void A4983::looprun()
{
  if(f_motor_enable == 1)  
  {    
    singlestep();
  }  
}
//---------------------------------------------------------------------------------------------
// enable loop mode
//---------------------------------------------------------------------------------------------
void A4983::loopstart()
{
  f_motor_enable = 1;
}
//---------------------------------------------------------------------------------------------
// disable loop mode
//---------------------------------------------------------------------------------------------
void A4983::loopstop()
{
  f_motor_enable = 0;
}
//---------------------------------------------------------------------------------------------