/* //---------------------------------------------------------------------------------------------
// RPC ServoCmd
http://192.168.1.100/rpc/servocmd1/run 0
http://192.168.1.100/rpc/servocmd1/run 50
http://192.168.1.100/rpc/servocmd1/run 100

http://192.168.1.100/rpc/servocmd2/run 0
http://192.168.1.100/rpc/servocmd2/run 50
http://192.168.1.100/rpc/servocmd2/run 100

// HTML5 demo (use chrome or html5 compatible browser)
-> copy servo.htm.cpp file to MBED internal flash memory (where the binary code is uploaded)
-> open file with an TextEditor and remove comments indicator chars "/*" and "*\/"
-> rename servo.htm.cpp to servo.htm
-> open browser http://192.168.1.100/servo.htm

// Hardware
-> Connect Servo1 Signal pin to P21 and Servo2 Signal pin to P22

//---------------------------------------------------------------------------------------------
// resources
//---------------------------------------------------------------------------------------------
http://mbed.org/handbook/C-Data-Types
http://mbed.org/cookbook/RPC-Interface-Library
http://mbed.org/cookbook/HTTP-Server
http://mbed.org/cookbook/Ethernet
http://mbed.org/handbook/Ticker
//--------------------------------------------------------------------------------------------- */
#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"
#include "RPCFunction.h"
#include "Servo.h"
//---------------------------------------------------------------------------------------------
DigitalOut myled(LED1);
Serial pc(USBTX, USBRX); // tx, rx
//---------------------------------------------------------------------------------------------
//#define internaldebug // send debug messages to USB Serial port (9600,1,N)
//#define dhcpenable    // auto-setup IP Address from DHCP router
//---------------------------------------------------------------------------------------------
// Timer Interrupt - NetPool
//---------------------------------------------------------------------------------------------
Ticker netpool;
//---------------------------------------------------------------------------------------------
// Ethernet Object Setup
//---------------------------------------------------------------------------------------------
#ifdef dhcpenable
  EthernetNetIf eth;  
#else
  EthernetNetIf eth(
    IpAddr(192,168,1,100), //IP Address
    IpAddr(255,255,255,0), //Network Mask
    IpAddr(192,168,1,254), //Gateway
    IpAddr(192,168,1,254)  //DNS
  );
#endif
//---------------------------------------------------------------------------------------------
// HTTP Server
//---------------------------------------------------------------------------------------------
HTTPServer httpserver;
LocalFileSystem fs("webfs");

Servo servo1(p21);
Servo servo2(p22);

int8_t servo_flag;
float servo_cursor1;
float servo_cursor2;

int8_t pool_flag;
//---------------------------------------------------------------------------------------------

//---------------------------------------------------------------------------------------------
// ISR -> Pool Ethernet - will be triggered by netpool ticker
//---------------------------------------------------------------------------------------------
void netpoolupdate()
{
  if(pool_flag !=0)
    return;

  pool_flag = 1; // start processing ...
  Net::poll();
  pool_flag = 0; // end processing ...
}
//---------------------------------------------------------------------------------------------

//---------------------------------------------------------------------------------------------
// Generic ServoCmd function
//---------------------------------------------------------------------------------------------
void servocmd(char *input, char *output, int8_t servonbr)
{
  if(servo_flag != 0) // busy ...
  {
    #ifdef internaldebug
      printf("ServoCmd%d is busy. Return from function!\r\n",servonbr);
    #endif
   
    return;  
  }
  servo_flag = 1; // REST request
  
  int iarg1 = 0;
  sscanf(input, "%i", &iarg1);
    
  #ifdef internaldebug
    printf("Calling RCP Function ServoCmd%d.\r\n",servonbr);
    //printf("INPUT: %s.\r\n", input);
    //printf("OUTPUT: %s.\r\n", output);
    printf("ARG1: %d\r\n", iarg1);
  #endif 
  
  if(servonbr == 1)
  {
    servo_cursor1 = (float)iarg1/(float)100.0;
    #ifdef internaldebug
      sprintf(output, "<html><body>RCP ServoCmd1 Completed!<br>PARAM=%d<br>Cursor=%f</body></html>", iarg1, servo_cursor1);
    #else
      sprintf(output, "<html><body>OK</body></html>");
    #endif
      
  }
  else if(servonbr == 2)
  {
    servo_cursor2 = (float)iarg1/(float)100.0;
    #ifdef internaldebug
      sprintf(output, "<html><body>RCP ServoCmd2 Completed!<br>PARAM=%d<br>Cursor=%f</body></html>", iarg1, servo_cursor2);
    #else
      sprintf(output, "<html><body>OK</body></html>");
    #endif      
  }
  else
  {
    #ifdef internaldebug    
      sprintf(output, "<html><body>RCP ServoCmd%d Error<br>PARAM=%d</body></html>", servonbr, iarg1);  
    #else
      sprintf(output, "<html><body>ERROR</body></html>");
    #endif      
  }
  
  servo_flag = 2; // can now update servos
}
//---------------------------------------------------------------------------------------------
// RPC TList Commands (Task/Job List)
//---------------------------------------------------------------------------------------------
/*
void rpc_dummy(char *input, char *output)
{
// dummy!!!
}
//--------------------------------------------------------------------------------------------- */

void rpc_servocmd1(char *input, char *output)
{
  servocmd(input, output, 1);
}
//---------------------------------------------------------------------------------------------

void rpc_servocmd2(char *input, char *output)
{
  servocmd(input, output, 2);
}
//---------------------------------------------------------------------------------------------

//---------------------------------------------------------------------------------------------
// MAIN
//---------------------------------------------------------------------------------------------
int main() 
{
  // Set Serial Port Transfer Rate
  pc.baud(115200);  
  
  //--------------------------------------------------------  
  servo_flag = 0; // 0-NOP; 1-REST request; 2-update servos;
  servo_cursor1 = 0.5;
  servo_cursor2 = 0.5; 
  servo1 = 0.5;
  servo2 = 0.5;
  
  pool_flag = 0;
  //--------------------------------------------------------
  // Setting Ethernet
  //--------------------------------------------------------    
  #ifdef internaldebug
    printf("\r\nSetting up Ethernet interface!\r\n");
  #endif
  // Create return object for error check
  EthernetErr ethErr = eth.setup(); 
  if(ethErr)
  {
    #ifdef internaldebug
      printf("\r\nError %d in Ethernet setup.\r\n", ethErr);
    #endif
    return -1;
  }
  #ifdef internaldebug
    printf("\r\nEthernet setup completed with success!\r\n");
  #endif  
  //--------------------------------------------------------    

  //--------------------------------------------------------
  // adding RPC functions
  //--------------------------------------------------------
  //RPCFunction RPCdummy(&rpc_dummy, "dummy");      
  RPCFunction RPCservocmd1(&rpc_servocmd1, "servocmd1");    
  RPCFunction RPCservocmd2(&rpc_servocmd2, "servocmd2");    
  //--------------------------------------------------------

  //--------------------------------------------------------
  // adding Handlers 
  //--------------------------------------------------------  
  FSHandler::mount("/webfs", "/"); //Mount /webfs path on web root path
 
  httpserver.addHandler<RPCHandler>("/rpc");
  httpserver.addHandler<FSHandler>("/"); //Default handler  
  //--------------------------------------------------------
  
  //--------------------------------------------------------
  // bind http server to port 80 (Listen)
  //--------------------------------------------------------       
  httpserver.bind(80);  
  #ifdef internaldebug
    printf("Listening on port 80!\r\n");
  #endif
  //--------------------------------------------------------         
    
  //--------------------------------------------------------
  // ISR -> attach timer interrupt to update Net::Pool();
  //--------------------------------------------------------
  //netpool.attach(&netpoolupdate, 0.1);
  //--------------------------------------------------------

  //--------------------------------------------------------    
  // main loop
  //--------------------------------------------------------    
  while(1) 
  { 
    /*   
    myled = 1;
    wait(0.5);
    myled = 0;
    wait(0.5);     
    */
    
    if(servo_flag == 2) // update servos
    {   
      #ifdef internaldebug
        printf("Updating Servos!\r\n");
      #endif
    
      servo1.write(servo_cursor1);
      servo2.write(servo_cursor2);
      servo_flag = 0; // NOP      
    }
    wait(0.1);
    netpoolupdate();
  }
}
//---------------------------------------------------------------------------------------------