/* //---------------------------------------------------------------------------------------------
// RPC DemoCmd
http://192.168.1.100/rpc/democmd/run%201000%20100%201
http://192.168.1.100/rpc/democmd/run 1000 100 1

//---------------------------------------------------------------------------------------------
// resources
//---------------------------------------------------------------------------------------------
http://mbed.org/handbook/C-Data-Types
http://mbed.org/cookbook/RPC-Interface-Library
http://mbed.org/cookbook/HTTP-Server
http://mbed.org/cookbook/Ethernet
http://mbed.org/handbook/Ticker
//--------------------------------------------------------------------------------------------- */
#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"
#include "RPCFunction.h"
//---------------------------------------------------------------------------------------------
DigitalOut myled(LED1);
Serial pc(USBTX, USBRX); // tx, rx
//---------------------------------------------------------------------------------------------
#define internaldebug // send debug messages to USB Serial port (9600,1,N)
//#define dhcpenable    // auto-setup IP Address from DHCP router
//---------------------------------------------------------------------------------------------
// Timer Interrupt - NetPool
//---------------------------------------------------------------------------------------------
Ticker netpool;
//---------------------------------------------------------------------------------------------
// Ethernet Object Setup
//---------------------------------------------------------------------------------------------
#ifdef dhcpenable
  EthernetNetIf eth;  
#else
  EthernetNetIf eth(
    IpAddr(192,168,1,100), //IP Address
    IpAddr(255,255,255,0), //Network Mask
    IpAddr(192,168,1,254), //Gateway
    IpAddr(192,168,1,254)  //DNS
  );
#endif
//---------------------------------------------------------------------------------------------
// HTTP Server
//---------------------------------------------------------------------------------------------
HTTPServer httpserver;
LocalFileSystem fs("webfs");

//---------------------------------------------------------------------------------------------

//---------------------------------------------------------------------------------------------
// ISR -> Pool Ethernet - will be triggered by netpool ticker
//---------------------------------------------------------------------------------------------
void netpoolupdate()
{
    Net::poll();
}
//---------------------------------------------------------------------------------------------

//---------------------------------------------------------------------------------------------
// RPC TList Commands (Task/Job List)
//---------------------------------------------------------------------------------------------
void rpc_democmd(char *input, char *output)
{
  int iarg1 = 0;
  int iarg2 = 0;
  int iarg3 = 0;
  
  sscanf(input, "%i %i %i", &iarg1, &iarg2, &iarg3);
    
  #ifdef internaldebug
    printf("Calling RCP Function DemoCmd.\r\n");
    printf("INPUT: %s.\r\n", input);
    printf("OUTPUT: %s.\r\n", output);
    printf("ARG1: %d\r\n", iarg1);
    printf("ARG2: %d\r\n", iarg2);
    printf("ARG3: %d\r\n", iarg3);
  #endif 
  
  sprintf(output, "<html><body>RCP Demo Cmd Completed!</body></html>");
}
//---------------------------------------------------------------------------------------------


//---------------------------------------------------------------------------------------------
// MAIN
//---------------------------------------------------------------------------------------------
int main() 
{
  // Set Serial Port Transfer Rate
  pc.baud(115200);  

  //--------------------------------------------------------
  // Setting Ethernet
  //--------------------------------------------------------    
  #ifdef internaldebug
    printf("\r\nSetting up Ethernet interface!\r\n");
  #endif
  // Create return object for error check
  EthernetErr ethErr = eth.setup(); 
  if(ethErr)
  {
    #ifdef internaldebug
      printf("\r\nError %d in Ethernet setup.\r\n", ethErr);
    #endif
    return -1;
  }
  #ifdef internaldebug
    printf("\r\nEthernet setup completed with success!\r\n");
  #endif  
  //--------------------------------------------------------    

  //--------------------------------------------------------
  // adding RPC functions
  //--------------------------------------------------------
  RPCFunction RPCdemocmd(&rpc_democmd, "democmd");  
  //--------------------------------------------------------

  //--------------------------------------------------------
  // adding Handlers 
  //--------------------------------------------------------  
  FSHandler::mount("/webfs", "/"); //Mount /webfs path on web root path
 
  httpserver.addHandler<RPCHandler>("/rpc");
  httpserver.addHandler<FSHandler>("/"); //Default handler  
  //--------------------------------------------------------
  
  //--------------------------------------------------------
  // bind http server to port 80 (Listen)
  //--------------------------------------------------------       
  httpserver.bind(80);  
  #ifdef internaldebug
    printf("Listening on port 80!\r\n");
  #endif
  //--------------------------------------------------------         
    
  //--------------------------------------------------------
  // ISR -> attach timer interrupt to update Net::Pool();
  //--------------------------------------------------------
  netpool.attach(&netpoolupdate, 0.1);
  //--------------------------------------------------------

  //--------------------------------------------------------    
  // main loop
  //--------------------------------------------------------    
  while(1) 
  {    
    myled = 1;
    wait(0.5);
    myled = 0;
    wait(0.5);     
  }
}
//---------------------------------------------------------------------------------------------