/* //---------------------------------------------------------------------------------------------
http://192.168.1.100/rpc/DigitalOut/new%20LED1%20myled1

http://192.168.1.100/rpc/DigitalOut/new LED1 myled1
http://192.168.1.100/rpc/DigitalOut/new LED2 myled2
http://192.168.1.100/rpc/DigitalOut/new LED3 myled3
http://192.168.1.100/rpc/DigitalOut/new LED4 myled4

http://192.168.1.100/rpc/

http://192.168.1.100/rpc/myled1/read
http://192.168.1.100/rpc/myled1/write 1

http://192.168.1.100/rpc/myled2/write 2
http://192.168.1.100/rpc/myled3/write 3
http://192.168.1.100/rpc/myled4/write 4

//---------------------------------------------------------------------------------------------
// resources
//---------------------------------------------------------------------------------------------
http://mbed.org/handbook/C-Data-Types
http://mbed.org/cookbook/RPC-Interface-Library
http://mbed.org/cookbook/HTTP-Server
http://mbed.org/cookbook/Ethernet
http://mbed.org/handbook/Ticker
//--------------------------------------------------------------------------------------------- */
#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"
#include "RPCVariable.h"
#include "RPCFunction.h"
//---------------------------------------------------------------------------------------------
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);
Serial pc(USBTX, USBRX); // tx, rx
//---------------------------------------------------------------------------------------------
#define internaldebug // send debug messages to USB Serial port (9600,1,N)
//#define dhcpenable    // auto-setup IP Address from DHCP router
//---------------------------------------------------------------------------------------------
// Timer Interrupt - NetPool
//---------------------------------------------------------------------------------------------
Ticker netpool;
//---------------------------------------------------------------------------------------------
// Ethernet Object Setup
//---------------------------------------------------------------------------------------------
#ifdef dhcpenable
  EthernetNetIf eth;  
#else
  EthernetNetIf eth(
    IpAddr(192,168,1,100), //IP Address
    IpAddr(255,255,255,0), //Network Mask
    IpAddr(192,168,1,254), //Gateway
    IpAddr(192,168,1,254)  //DNS
  );
#endif
//---------------------------------------------------------------------------------------------
// HTTP Server
//---------------------------------------------------------------------------------------------
HTTPServer httpserver;
LocalFileSystem fs("webfs");
//---------------------------------------------------------------------------------------------

//---------------------------------------------------------------------------------------------
// ISR -> Pool Ethernet - will be triggered by netpool ticker
//---------------------------------------------------------------------------------------------
void netpoolupdate()
{
    Net::poll();
}
//---------------------------------------------------------------------------------------------

//---------------------------------------------------------------------------------------------
// MAIN
//---------------------------------------------------------------------------------------------
int main() 
{
  // Set Serial Port Transfer Rate
  pc.baud(115200);  
  
  //--------------------------------------------------------
  // Setting RPC
  //--------------------------------------------------------  
  Base::add_rpc_class<AnalogIn>();
  Base::add_rpc_class<AnalogOut>();
  Base::add_rpc_class<DigitalIn>();
  Base::add_rpc_class<DigitalOut>();
  Base::add_rpc_class<DigitalInOut>();
  Base::add_rpc_class<PwmOut>();
  Base::add_rpc_class<Timer>();
  Base::add_rpc_class<SPI>();
  Base::add_rpc_class<BusOut>();
  Base::add_rpc_class<BusIn>();
  Base::add_rpc_class<BusInOut>();
  Base::add_rpc_class<Serial>();   
  //--------------------------------------------------------  

  //--------------------------------------------------------
  // Setting Ethernet
  //--------------------------------------------------------    
  #ifdef internaldebug
    printf("\r\nSetting up Ethernet interface!\r\n");
  #endif
  // Create return object for error check
  EthernetErr ethErr = eth.setup(); 
  if(ethErr)
  {
    #ifdef internaldebug
      printf("\r\nError %d in Ethernet setup.\r\n", ethErr);
    #endif
    return -1;
  }
  #ifdef internaldebug
    printf("\r\nEthernet setup completed with success!\r\n");
  #endif  
  //--------------------------------------------------------    

  //--------------------------------------------------------
  // adding Handlers 
  //--------------------------------------------------------  
  FSHandler::mount("/webfs", "/"); //Mount /webfs path on web root path
 
  httpserver.addHandler<RPCHandler>("/rpc");
  httpserver.addHandler<FSHandler>("/"); //Default handler  
  //--------------------------------------------------------
  
  //--------------------------------------------------------
  // bind http server to port 80 (Listen)
  //--------------------------------------------------------       
  httpserver.bind(80);  
  #ifdef internaldebug
    printf("Listening on port 80!\r\n");
  #endif
  //--------------------------------------------------------         
    
  //--------------------------------------------------------
  // ISR -> attach timer interrupt to update Net::Pool();
  //--------------------------------------------------------
  netpool.attach(&netpoolupdate, 0.1);
  //--------------------------------------------------------

  //--------------------------------------------------------    
  // main loop
  //--------------------------------------------------------    
  // main loop
  while(1) 
    wait(0.5);
}
//---------------------------------------------------------------------------------------------