//---------------------------------------------------------------------------------------------
/*
Copyright (c) 2010 ARM Ltd
 
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:
 
The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.
 
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/
//---------------------------------------------------------------------------------------------
#include "mbed.h"
#include "EthernetNetIf.h"
#include "SuperTweetV1XML.h"
#include "twitter_config.h"
//---------------------------------------------------------------------------------------------
DigitalOut myled(LED1);
DigitalIn button(p20);
Serial pc(USBTX, USBRX); // tx, rx
//---------------------------------------------------------------------------------------------
#define internaldebug // send debug messages to USB Serial port (9600,1,N)
//#define dhcpenable    // auto-setup IP Address from DHCP router
//---------------------------------------------------------------------------------------------
// Ethernet Object Setup
//---------------------------------------------------------------------------------------------
#ifdef dhcpenable
  EthernetNetIf eth;  
#else
  EthernetNetIf eth(
    IpAddr(192,168,1,100), //IP Address
    IpAddr(255,255,255,0), //Network Mask
    IpAddr(192,168,1,254), //Gateway
    IpAddr(192,168,1,254)  //DNS
  );
#endif
//---------------------------------------------------------------------------------------------
// GLOBAL VARS / FUNCTIONS
//---------------------------------------------------------------------------------------------
// SuperTweet - Twitter account data (twitter_config.h)
//#define YOUR_ACCOUNT    "twitterid"
//#define YOUR_PASSWORD   "passwd"

SuperTweetV1XML st(YOUR_ACCOUNT, YOUR_PASSWORD);

/**
 * Callback function for postStatusesUpdate.
 *
 * @param buf A pointer to a buffer.
 * @param siz A size of the buffer.
 */
void func(char *buf, size_t siz) 
{
#if 0
    // This is for checking a response.     
    for(int i = 0; i < siz; i++)
    { 
      printf("%c", buf[i]);
    }
#endif
}
//---------------------------------------------------------------------------------------------
// MISC
//---------------------------------------------------------------------------------------------
// Hack - Expose 'special' internal mbed ethernet functions
extern "C" void mbed_reset();
//extern "C" void mbed_mac_address(char *mac);

//---------------------------------------------------------------------------------------------
// Global Functions
//---------------------------------------------------------------------------------------------
void SendTweet(char *pMessage)
{   
  #ifdef internaldebug
    printf("\r\n %s \r\n",pMessage);
  #endif  

  HTTPResult r = st.postStatusesUpdate(std::string(pMessage), func);
  printf("r=%d\n", (int)r);
  /*
  * Note:
  * I don't know why sometime it get a error.
  * I think it a bug in a mbed library.
  */
  if (r != 0) 
  {
    printf("Resetting...\n");
    mbed_reset();
  }    
}
//---------------------------------------------------------------------------------------------
// MAIN
//---------------------------------------------------------------------------------------------
int main() 
{
  char text[1024];
  
  // Set Serial Port Transfer Rate
  pc.baud(115200);    

  //--------------------------------------------------------
  // Setting Ethernet
  //--------------------------------------------------------    
  #ifdef internaldebug
    printf("\r\nSetting up Ethernet interface!\r\n");
  #endif
  // Create return object for error check
  EthernetErr ethErr = eth.setup(); 
  if(ethErr)
  {
    #ifdef internaldebug
      printf("\r\nError %d in Ethernet setup.\r\n", ethErr);
    #endif
    return -1;
  }
  #ifdef internaldebug
    printf("\r\nEthernet setup completed with success!\r\n");
  #endif  
  //--------------------------------------------------------    

  wait(5);

  //--------------------------------------------------------    
  // Post IP/MAC address into Twitter
  //--------------------------------------------------------    
  // Get IP Address
  IpAddr ip = eth.getIp();
  
  // Sending Twitter Message
  snprintf(text, sizeof(text), "Auto-posting from ARM Microcontroller mbed NXP LPC1768 from: %d.%d.%d.%d", ip[0], ip[1], ip[2], ip[3]); 

  SendTweet(&text[0]);  
  //--------------------------------------------------------    

  // main loop
  bool flag_sending = false;
  while(1) 
  {  
    if(!button)
    {
      if(flag_sending)
        continue;
    
      myled = 1;

      // Sending Twitter Message (custom)
      snprintf(text, sizeof(text), "Button Pressed Message sent from ARM Microcontroller mbed NXP LPC1768"); 

      SendTweet(&text[0]);        
      
      flag_sending = true;
    }
    else
    {
      myled = 0;
      flag_sending = false;
    }

    // debounce time!
    wait(0.1);
  }
}
//---------------------------------------------------------------------------------------------