//---------------------------------------------------------------------------------------------
#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"
//---------------------------------------------------------------------------------------------
DigitalOut myled(LED1);
Serial pc(USBTX, USBRX); // tx, rx
//---------------------------------------------------------------------------------------------
#define internaldebug // send debug messages to USB Serial port (9600,1,N)
#define dhcpenable    // auto-setup IP Address from DHCP router
//---------------------------------------------------------------------------------------------
// Ethernet Object Setup
//---------------------------------------------------------------------------------------------
#ifdef dhcpenable
  EthernetNetIf eth;  
#else
  EthernetNetIf eth(
    IpAddr(192,168,1,100), //IP Address
    IpAddr(255,255,255,0), //Network Mask
    IpAddr(192,168,1,254), //Gateway
    IpAddr(192,168,1,254)  //DNS
  );
#endif
//---------------------------------------------------------------------------------------------
// HttpClient
HTTPClient http;

HTTPResult result;
bool completed = false;
void request_callback(HTTPResult r)
{
  result = r;
  completed = true;
}
//---------------------------------------------------------------------------------------------
// MAIN
//---------------------------------------------------------------------------------------------
int main() 
{
  // Set Serial Port Transfer Rate
  pc.baud(115200);  

  //--------------------------------------------------------
  // Setting Ethernet
  //--------------------------------------------------------    
  #ifdef internaldebug
    printf("\r\nSetting up Ethernet interface!\r\n");
  #endif
  // Create return object for error check
  EthernetErr ethErr = eth.setup(); 
  if(ethErr)
  {
    #ifdef internaldebug
      printf("\r\nError %d in Ethernet setup.\r\n", ethErr);
    #endif
    return -1;
  }
  #ifdef internaldebug
    printf("\r\nEthernet setup completed with success!\r\n");
  #endif  
  //--------------------------------------------------------    

  //--------------------------------------------------------    
  // HTTP Get Stream Request
  //--------------------------------------------------------    
  HTTPStream stream;
  
  char BigBuf[512 + 1] = {0};
  stream.readNext((byte*)BigBuf, 512); //Point to buffer for the first read
  
  printf("\r\nHttpClient Get Stream Request ...\r\n");
  
  HTTPResult r = http.get("http://services.sapo.pt/RSS/Feed/tek", &stream, request_callback); //Load a very large page, such as the hackaday RSS feed
  
  while(!completed)
  {
    Net::poll(); //Polls the Networking stack
    if(stream.readable())
    {
      BigBuf[stream.readLen()] = 0; //Transform this buffer in a zero-terminated char* string
      printf("%s\r\n",BigBuf); //Display it while loading
      //Note: some servers do not like if you throttle them too much, so printf'ing during a request is generally bad practice
      stream.readNext((byte*)BigBuf, 512); //Buffer has been read, now we can put more data in it
    }
  }
  printf("\n--------------\n");
  if(result == HTTP_OK)
  {
    printf("Read completely\n"); 
  }
  else
  {
    printf("Error %d\n", result);
  }
  //--------------------------------------------------------    

  // main loop
  while(1) 
  {
    myled = 1;
    wait(0.5);
    myled = 0;
    wait(0.5);
  }
}
//---------------------------------------------------------------------------------------------