//---------------------------------------------------------------------------------------------
#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"
//---------------------------------------------------------------------------------------------
DigitalOut myled(LED1);
Serial pc(USBTX, USBRX); // tx, rx
//---------------------------------------------------------------------------------------------
#define internaldebug // send debug messages to USB Serial port (9600,1,N)
#define dhcpenable    // auto-setup IP Address from DHCP router
//---------------------------------------------------------------------------------------------
// Ethernet Object Setup
//---------------------------------------------------------------------------------------------
#ifdef dhcpenable
  EthernetNetIf eth;  
#else
  EthernetNetIf eth(
    IpAddr(192,168,1,100), //IP Address
    IpAddr(255,255,255,0), //Network Mask
    IpAddr(192,168,1,254), //Gateway
    IpAddr(192,168,1,254)  //DNS
  );
#endif

HTTPClient http;
//---------------------------------------------------------------------------------------------
// MAIN
//---------------------------------------------------------------------------------------------
int main() 
{
  // Set Serial Port Transfer Rate
  pc.baud(115200);  
  
  //--------------------------------------------------------
  // Setting Ethernet
  //--------------------------------------------------------    
  #ifdef internaldebug
    printf("\r\nSetting up Ethernet interface!\r\n");
  #endif
  // Create return object for error check
  EthernetErr ethErr = eth.setup(); 
  if(ethErr)
  {
    #ifdef internaldebug
      printf("\r\nError %d in Ethernet setup.\r\n", ethErr);
    #endif
    return -1;
  }
  #ifdef internaldebug
    printf("\r\nEthernet setup completed with success!\r\n");
  #endif  
  //--------------------------------------------------------    

  //--------------------------------------------------------    
  // HTTP Get Request
  //--------------------------------------------------------    
  HTTPText txt;
  
  HTTPResult r = http.get("http://botdream.com/robots.txt", &txt);
  if(r==HTTP_OK)
  {
    printf("Result :\"%s\"\n", txt.gets()); 
  }
  else
  {
    printf("Error %d\n", r);
  }
  //--------------------------------------------------------    

  // main loop
  while(1) 
  {
    myled = 1;
    wait(0.5);
    myled = 0;
    wait(0.5);
  }
}
//---------------------------------------------------------------------------------------------