//---------------------------------------------------------------------------------------------
// CurrentCost XML Serial Data Emulator
//---------------------------------------------------------------------------------------------
// Simulating OptiSmart TX device with 2 configured sensors (0 and 9) 
// and additional IAM power plug sensor (1):
//
// http://www.currentcost.com/cc128/xml.htm
// http://currentcost.com/support/viewtopic.php?f=24&t=1284
// https://docs.google.com/document/pub?id=1-Saz_uA8r6HJzGNoNTF2zpwz7BcjTTwpf0HOlhCpuGY
//---------------------------------------------------------------------------------------------
// Objectives: to emulate CurrentCost (EnviR Device) functionality to send XML data 
// via USB Serial Port to be used to develop custom software application.
//---------------------------------------------------------------------------------------------
#include "mbed.h"
#include <string>
using std::string;
//---------------------------------------------------------------------------------------------

//---------------------------------------------------------------------------------------------
// USB serial port setup - debug messages
//---------------------------------------------------------------------------------------------
Serial pc(USBTX, USBRX); // tx, rx  
//---------------------------------------------------------------------------------------------  

DigitalOut myled(LED1);

//---------------------------------------------------------------------------------------------
// Main
//---------------------------------------------------------------------------------------------
int main() 
{ 
  uint16_t impulse = 30733;
  uint16_t power;
  
  // setup time structure for Wed, 28 Oct 2009 11:35:37
  char buffer[32];
  struct tm t;
  t.tm_sec = 01;    // 0-59
  t.tm_min = 35;    // 0-59
  t.tm_hour = 23;   // 0-23
  t.tm_mday = 5;   // 1-31
  t.tm_mon = 4;     // 0-11
  t.tm_year = 112;  // year since 1900

  string data1 = "<msg><src>CC128-v1.29</src><dsb>00381</dsb><time>DATETIME</time><tmpr>26.1</tmpr><sensor>9</sensor><id>02063</id><type>2</type><imp>IMPULSE</imp><ipu>1000</ipu></msg>";
  string data2 = "<msg><src>CC128-v1.29</src><dsb>00381</dsb><time>DATETIME</time><tmpr>26.0</tmpr><sensor>1</sensor><id>00815</id><type>1</type><ch1><watts>POWER</watts></ch1></msg>";
  string data3 = "<msg><src>CC128-v1.29</src><dsb>00381</dsb><time>DATETIME</time><tmpr>26.0</tmpr><sensor>0</sensor><id>03386</id><type>1</type><ch1><watts>POWER</watts></ch1></msg>";
  string parsedata;  

  pc.baud(57600);  
  pc.printf("\r\n--- CurrentCost XML Data Emulator---\r\n");  
  
  // convert to timestamp and display (1256729737)
  time_t seconds = mktime(&t);
  //pc.printf("Time as seconds since January 1, 1970 = %d\r\n", seconds);            

  while(1) 
  {        
    myled = 1;
   
    // increments datetime
    seconds = seconds + 1;
    // gets datetime formated data
    strftime(buffer, 32, "%H:%M:%S", localtime(&seconds));
    // replaces data with current datetime    
    parsedata = data1;
    parsedata.replace(parsedata.find("DATETIME"), string("DATETIME").length(), buffer);
    // format impulse        
    sprintf(buffer, "%010u", impulse); // 0000030733    
    parsedata.replace(parsedata.find("IMPULSE"), string("IMPULSE").length(), buffer);
    impulse = impulse + 1;   
        
    // sends XML data
    pc.printf("%s\r\n",parsedata.c_str());
    wait(1);

    myled = 0;
    
    // increments datetime
    seconds = seconds + 1;
    // gets datetime formated data
    strftime(buffer, 32, "%H:%M:%S", localtime(&seconds));
    // replaces data with current datetime    
    parsedata = data2;
    parsedata.replace(parsedata.find("DATETIME"), string("DATETIME").length(), buffer);
    // format power
    sprintf(buffer, "%05u", power); // 00715
    parsedata.replace(parsedata.find("POWER"), string("POWER").length(), buffer);
    power = rand()%2500;
    
    // sends XML data
    pc.printf("%s\r\n",parsedata.c_str());
    wait(1);        
    
    
    // increments datetime
    seconds = seconds + 1;
    // gets datetime formated data
    strftime(buffer, 32, "%H:%M:%S", localtime(&seconds));
    // replaces data with current datetime    
    parsedata = data3;
    parsedata.replace(parsedata.find("DATETIME"), string("DATETIME").length(), buffer);
    // format power
    sprintf(buffer, "%05u", power); // 00715
    parsedata.replace(parsedata.find("POWER"), string("POWER").length(), buffer);
    power = rand()%2500;

    // sends XML data
    pc.printf("%s\r\n",parsedata.c_str());
    wait(1);
  }    
  //return -1;
}
//---------------------------------------------------------------------------------------------