#include "mbed.h"
#include "EthernetInterface.h"

#define WADDR

#ifdef WADDR
#define IP_ADDR   "169.254.65.200"
#define NET_MASK  "255.255.0.0"
#define GATW_ADDR "169.254.65.1"
#define IP_ADDR_REMOTE "169.254.65.199"
#else
#define IP_ADDR   "192.168.1.10"
#define NET_MASK  "255.255.255.0"
#define GATW_ADDR "192.168.1.1"
#define IP_ADDR_R "192.168.1.9"
#endif




EthernetInterface eth;
nsapi_error_t err;


int main(void)
{
  //  if( (err = eth.disconnect()) != NSAPI_ERROR_OK )  { printf(" greska diskonekcije %d \n\r", err); return 1; } 
  //  ((NetworkInterface *)&eth)->set_network("192.168.1.11","255.255.255.0","192.168.1.1");
 
    if( (err = eth.set_network(IP_ADDR,NET_MASK,GATW_ADDR))!= NSAPI_ERROR_OK )  { printf(" greska setovanja mreze %d \n\r", err); return 1; } 
    
    
     if( (err = eth.connect())  != NSAPI_ERROR_OK )  { printf(" greska konekcije %d \n\r", err); return 1; }
    
    const char *ip = eth.get_ip_address() ;
    
    
    printf( "MAC adresa: %s\n\r", eth.get_mac_address() );
    printf( "IP adresa:  %s\n\r", ip);
    printf( "net mask:   %s\n\r", eth.get_netmask() );
    printf( "GW adresa:  %s\n\r", eth.get_gateway() );
    
    
    /*
    TCPSocket socket;        
    socket.open(&eth);
    socket.connect(
    */
    
    UDPSocket udpSocket;
    if( (err = udpSocket.open( &eth ))  != NSAPI_ERROR_OK )  { printf(" greska otvaranja soketa %d \n\r", err);  return 1; }
    udpSocket.bind(2000);
    
    char buff[]="text poruke";
    char inbuff[100];
    printf("POCINJE\r\n");
    int i=0;
    while(1)
   {
    printf("petlja\r\n");
    SocketAddress sockAddr;
 
printf("cekam prijem \n\r");
int n = udpSocket.recvfrom(&sockAddr, &inbuff, sizeof(inbuff));
printf(" primljeno = %d bajtova \n\r",n);
for(i=0;i<n;i++)  printf(" %c ", inbuff[i] );

    if(0 > udpSocket.sendto(IP_ADDR_REMOTE, sockAddr.get_port(), buff, sizeof(buff))) 
     {
        printf("Error sending data\n");
        return -1;
    }
    else printf("super slanje %s  na adresu %s , port %d\r\n",buff,sockAddr.get_ip_address(), sockAddr.get_port());
    
    wait(1);
    } 
}

//
//enum nsapi_error {
//    NSAPI_ERROR_OK                  =  0,        /*!< no error */
//    NSAPI_ERROR_WOULD_BLOCK         = -3001,     /*!< no data is not available but call is non-blocking */
//    NSAPI_ERROR_UNSUPPORTED         = -3002,     /*!< unsupported functionality */
//    NSAPI_ERROR_PARAMETER           = -3003,     /*!< invalid configuration */
//    NSAPI_ERROR_NO_CONNECTION       = -3004,     /*!< not connected to a network */
//    NSAPI_ERROR_NO_SOCKET           = -3005,     /*!< socket not available for use */
//    NSAPI_ERROR_NO_ADDRESS          = -3006,     /*!< IP address is not known */
//    NSAPI_ERROR_NO_MEMORY           = -3007,     /*!< memory resource not available */
//    NSAPI_ERROR_NO_SSID             = -3008,     /*!< ssid not found */
//    NSAPI_ERROR_DNS_FAILURE         = -3009,     /*!< DNS failed to complete successfully */
//    NSAPI_ERROR_DHCP_FAILURE        = -3010,     /*!< DHCP failed to complete successfully */
//    NSAPI_ERROR_AUTH_FAILURE        = -3011,     /*!< connection to access point failed */
//    NSAPI_ERROR_DEVICE_ERROR        = -3012,     /*!< failure interfacing with the network processor */
//    NSAPI_ERROR_IN_PROGRESS         = -3013,     /*!< operation (eg connect) in progress */
//    NSAPI_ERROR_ALREADY             = -3014,     /*!< operation (eg connect) already in progress */
//    NSAPI_ERROR_IS_CONNECTED        = -3015,     /*!< socket is already connected */
//    NSAPI_ERROR_CONNECTION_LOST     = -3016,     /*!< connection lost */
//    NSAPI_ERROR_CONNECTION_TIMEOUT  = -3017,     /*!< connection timed out */
//};