#ifndef dataFlash_h
#define dataFlash_h

#include "EthernetSetup.h"
#include "doHTML.h"

//struct S_FlashData
//{
//    struct S_EthernetAddress s_EthAdd;
//    char serverPortUdp[6];
//    char serverPortTcp[6];
//    struct S_EthernetAddress_Remote s_EthAddRemUdp[3];
////    struct S_EthernetAddress_RangeRemote s_EthAddRangeRemUDP;
//    struct S_EthernetAddress_Remote s_EthAddRemTcp[3];
////    struct S_EthernetAddress_RangeRemote s_EthAddRangeRemTcp;
//    char baud_rate[7], parity[6], data_bits[2], stop_bits[4];
//};


struct S_FlashData
{
    char myIP[16];
    char myMASK[16];
    char myGATE[16];
    char myUdpPort[6];
    char myTcpPort[6];
    char UdpIP[5][16];
    char UdpPort[4][6];
    char TcpIP[5][16];
    char TcpPort[4][6];
    char baud_rate[7], parity[6], data_bits[2], stop_bits[4];
};




union U_FlashData
{
    struct S_FlashData s_flashData;
    char data[sizeof( struct S_FlashData )];
};



void progDataIntoFlash( struct S_FlashData *ps_fd );

void readDataFromFlash( struct S_FlashData *ps_fd );

void fillDataIntoFlash( void );

void refreshDataFromFlash( void );


void init_FlashData( void );

void deinit_FlashData( void );

void showFlashData( void );



void putHTMLintoFLASH( C_HTMLparse * );
void putFLASHintoHTML( C_HTMLparse * );

char * get_myIPfromFlash( void ); 
char *get_myMASKfromFlash(void ); 
char *get_myGATEfromFlash( void ); 



#endif
