#include "mbed.h"
#include "clubbing.h"
#include "EthernetSetup.h"
#include "Udp.h"
#include "doHTML.h"
struct S_EthernetAddress_Remote
/*{
  char ip[16];
  int port;   
}*/ s_EthAddRemote = {"192.168.1.14", 13000 }, *ps_ear = &s_EthAddRemote;

char lokaUdpPort[6] = "13000", localUdpPortFlash[6] = "65535";

/* globalni pointeri*/


extern EthernetInterface *gp_eth;

UDPSocket *gp_udpSocket = NULL;
Thread *gp_udpRxThread = NULL;

/************* inicijalizacija parametara  **********************/

extern C_HTMLparse * gpc_html;
void init_udp_param( void )
{
    strcpy( ps_ear->ip, gpc_html->get_UdpIP(1) );
    ps_ear->port = atoi( gpc_html->get_UdpPort(1) );

    printf(" UDP IP adresa: %s   %d \n\r",   ps_ear->ip, ps_ear->port );
}






/***************** Predaja na UDP  ****************************/

void sendUdp( struct S_EthernetAddress_Remote *ps_ear, char *buffer, int val )
{   
  if( gp_udpSocket )
  {
    printf(" UDPpaket ip=%s port=%d val=%d\n\r", ps_ear->ip, ps_ear->port, val);
    gp_udpSocket->sendto(ps_ear->ip, ps_ear->port, (const uint8_t*)buffer, val);
  }
  else printf("UDPsocket == NULL\n\r");
}

void sendToUdp( char *buffer, int val )
{
   sendUdp( ps_ear, buffer, val );
}



/***************  Prijem na UDP socket i predaja na Serial com ***************/

void udpRx_fun( void )
{
//int *p = (int*)pp;
   nsapi_error_t err;

    char inbuff[1500];

  //  if(gp_udpSocket == NULL)
    {
         gp_udpSocket = new UDPSocket;
        printf("___novi UDP socket %x\n\r", gp_udpSocket);
     init_udp_param(  );

         if( (err = gp_udpSocket->open( gp_eth ))  != NSAPI_ERROR_OK )  
            { printf(" greska otvaranja soketa %d \n\r", err);  }
         gp_udpSocket->bind(ps_ear->port);
         gp_udpSocket->set_timeout(1000);
    }
    printf("UDPrx inicijalizovan \n\r");


signed int n=0;
    while( !(ThisThread::flags_get( ) & 1) )
   {
        SocketAddress sockAddr;
       if( (n>=0) && gp_udpSocket )
       {
        int n = gp_udpSocket->recvfrom(&sockAddr, &inbuff, sizeof(inbuff));

        if(n>0) { extern void sendToScom(  char *buffer, int val ); sendToScom( inbuff, n); }
        else if(n==-3001)  n = 0;
        else break;
       }
       //else wait(0.1);
    } 
    
    if(gp_udpSocket) { delete gp_udpSocket; gp_udpSocket = NULL;}
    printf("udpSocket obrisan\n\r");
    fflush(stdout);
}


void udpRxThreadCancel( void )
{
     /* Gasenje UDP threada  */
     if( gp_udpRxThread->get_state( ) && gp_udpRxThread->get_state( )<16 )
        gp_udpRxThread->flags_set( 1 );
     gp_udpRxThread->join( );
     if(gp_udpRxThread) {delete gp_udpRxThread; gp_udpRxThread = NULL;}
     printf("udp thread zavrsio\n\r");
    
}

void udpRxThreadRiseUp( void )
{
     /* paljenje UDP thread-a */
     gp_udpRxThread = new Thread( udpRx_fun );
}

void udpRxThreadRestart( void )
{
    udpRxThreadCancel( );
    udpRxThreadRiseUp( );
}

