#include "dataFlash.h"

#include "flashDataBlock.h"
#include "EthernetSetup.h"
#include "clubbing.h"
#include "dataFlash.h"

#include "doHTML.h"




struct S_FlashData s_ramData,  *gps_rd = &s_ramData; //RAM podaci


/***********  upis/citanje na ram         */
void progDataIntoFlash( struct S_FlashData *ps_fd )
{
   write_niz_in_flash( 0, (char *)ps_fd, sizeof(S_FlashData) );
}

void readDataFromFlash( struct S_FlashData *ps_fd )
{
     read_fdb( 0, (char*)ps_fd, sizeof(struct S_FlashData) );
}


/*   upis citanje u RAM na koji pokazuje globalni pointer  gps_rd  */
void fillDataIntoFlash( void )
{
   progDataIntoFlash(  gps_rd );
  // write_niz_in_flash( 0, (char *)gps_rd, sizeof(S_FlashData) );
}
void refreshDataFromFlash( void )
{
     readDataFromFlash( gps_rd );
//     read_fdb( 0, (char*)gps_rd, sizeof(struct S_FlashData) );
}


void init_FlashData( void )
{
   init_fdb( );
   readDataFromFlash( gps_rd );

}


void deinit_FlashData( void )
{
   deinit_fdb( ); 
}

void showFlashData( void )
{
  refreshDataFromFlash( );
   P_str( "FLASH IP ", gps_rd->myIP ); 
   P_str( "FLASH MASK ", gps_rd->myMASK ); 
   P_str( "FLASH GATE ", gps_rd->myGATE ); 

   P_str( "FLASH UDP PORT ", gps_rd->myUdpPort ); 
   P_str( "FLASH TCP PORT ", gps_rd->myTcpPort ); 
   
   P_str( "FLASH UDP IP[0] ", gps_rd->UdpIP[0] ); 
   P_str( "FLASH UDP IP[1] ", gps_rd->UdpIP[1] ); 
   P_str( "FLASH UDP IP[2] ", gps_rd->UdpIP[2] ); 
   P_str( "FLASH UDP IP[3] ", gps_rd->UdpIP[3] ); 
   P_str( "FLASH UDP IP[4] ", gps_rd->UdpIP[4] ); 

   P_str( "FLASH UDP PORT[0] ", gps_rd->UdpPort[0] ); 
   P_str( "FLASH UDP PORT[1] ", gps_rd->UdpPort[1] ); 
   P_str( "FLASH UDP PORT[2] ", gps_rd->UdpPort[2] ); 
   P_str( "FLASH UDP PORT[3] ", gps_rd->UdpPort[3] ); 

   P_str( "FLASH TCP IP[0] ", gps_rd->TcpIP[0] ); 
   P_str( "FLASH TCP IP[1] ", gps_rd->TcpIP[1] ); 
   P_str( "FLASH TCP IP[2] ", gps_rd->TcpIP[2] ); 
   P_str( "FLASH TCP IP[3] ", gps_rd->TcpIP[3] ); 
   P_str( "FLASH TCP IP[4] ", gps_rd->TcpIP[4] ); 

   P_str( "FLASH TCP PORT[0] ", gps_rd->TcpPort[0] ); 
   P_str( "FLASH TCP PORT[1] ", gps_rd->TcpPort[1] ); 
   P_str( "FLASH TCP PORT[2] ", gps_rd->TcpPort[2] ); 
   P_str( "FLASH TCP PORT[3] ", gps_rd->TcpPort[3] ); 
   
   P_str( "FLASH SERIAL BAUD ", gps_rd->baud_rate ); 
   P_str( "FLASH SERIAL BAUD ", gps_rd->parity ); 
   P_str( "FLASH SERIAL BAUD ", gps_rd->data_bits ); 
   P_str( "FLASH SERIAL BAUD ", gps_rd->stop_bits ); 
} 


//
//struct S_FlashData
//{
//    char myIP[16];
//    char myMask[16];
//    char myGate[16];
//    char myUdpPort[6];
//    char myTcpPort[6];
//    char UdpIP[5][16];
//    char UdpPort[4][6];
//    char TcpPort[4][6];
//    char baud_rate[7], parity[6], data_bits[2], stop_bits[4];
//};



//#define COPY_IP_TO_FLASH( dest, source )      if( test_ip( pch->source ) ) strncpy( gps_rd->dest, pch->source, 16 )

#define COPY_IP_HTML_TO_FLASH( param )      if( test_ip( pch->get_##param() ) ) strncpy( gps_rd->param, pch->get_##param(), 16 )
#define COPY_IP_HTML_TO_FLASH_idx( param, idx )      \
    if( test_ip( pch->get_##param(idx+1) ) ) strncpy( gps_rd->param[idx], pch->get_##param(idx+1), 16 );         \
    else strncpy( gps_rd->param[idx], " ", 16 );


//#define COPY_PORT_TO_FLASH( dest, source )      if( test_num( pch->source)) strncpy( gps_rd->dest, pch->source, 6 );
#define COPY_PORT_HTML_TO_FLASH( param )      if( test_num( pch->get_##param())) strncpy( gps_rd->param, pch->get_##param( ), 6 );
#define COPY_PORT_HTML_TO_FLASH_idx( param, idx )      \
    if( test_num( pch->get_##param(idx+1))) strncpy( gps_rd->param[idx], pch->get_##param( idx+1 ), 6 );   \
    else strncpy( gps_rd->param[idx], " ", 6 );


void putHTMLintoFLASH( C_HTMLparse *pch )
{
    
 //   COPY_IP_TO_FLASH( myIP, get_myIP() );
COPY_IP_HTML_TO_FLASH( myIP );
COPY_IP_HTML_TO_FLASH( myMASK );
COPY_IP_HTML_TO_FLASH( myGATE );
 
//    COPY_IP_TO_FLASH( myMASK, get_myMASK() );
//    COPY_IP_TO_FLASH( myGATE, get_myGATE() );

COPY_PORT_HTML_TO_FLASH( myUdpPort );
COPY_PORT_HTML_TO_FLASH( myTcpPort );
//    COPY_PORT_TO_FLASH( myUdpPort, get_myUdpPort() );
//    COPY_PORT_TO_FLASH( myTcpPort, get_myTcpPort() );

COPY_IP_HTML_TO_FLASH_idx( UdpIP, 0 );    
COPY_IP_HTML_TO_FLASH_idx( UdpIP, 1 );    
COPY_IP_HTML_TO_FLASH_idx( UdpIP, 2 );    
COPY_IP_HTML_TO_FLASH_idx( UdpIP, 3 );    
COPY_IP_HTML_TO_FLASH_idx( UdpIP, 4 );    
//    COPY_IP_TO_FLASH( UdpIP[0], get_UdpIP(1) );
//    COPY_IP_TO_FLASH( UdpIP[1], get_UdpIP(2) );
//    COPY_IP_TO_FLASH( UdpIP[2], get_UdpIP(3) );
//    COPY_IP_TO_FLASH( UdpIP[3], get_UdpIP(4) );
//    COPY_IP_TO_FLASH( UdpIP[4], get_UdpIP(5) );

COPY_PORT_HTML_TO_FLASH_idx( UdpPort, 0 );
COPY_PORT_HTML_TO_FLASH_idx( UdpPort, 1 );
COPY_PORT_HTML_TO_FLASH_idx( UdpPort, 2 );
COPY_PORT_HTML_TO_FLASH_idx( UdpPort, 3 );
//    COPY_PORT_TO_FLASH( UdpPort[0], get_UdpPort(1) );
//    COPY_PORT_TO_FLASH( UdpPort[1], get_UdpPort(2) );
//    COPY_PORT_TO_FLASH( UdpPort[2], get_UdpPort(3) );
//    COPY_PORT_TO_FLASH( UdpPort[3], get_UdpPort(4) );

COPY_IP_HTML_TO_FLASH_idx( TcpIP, 0 );    
COPY_IP_HTML_TO_FLASH_idx( TcpIP, 1 );    
COPY_IP_HTML_TO_FLASH_idx( TcpIP, 2 );    
COPY_IP_HTML_TO_FLASH_idx( TcpIP, 3 );    
COPY_IP_HTML_TO_FLASH_idx( TcpIP, 4 );    
//    COPY_IP_TO_FLASH( TcpIP[0], get_TcpIP(1) );
//    COPY_IP_TO_FLASH( TcpIP[1], get_TcpIP(2) );
//    COPY_IP_TO_FLASH( TcpIP[2], get_TcpIP(3) );
//    COPY_IP_TO_FLASH( TcpIP[3], get_TcpIP(4) );
//    COPY_IP_TO_FLASH( TcpIP[4], get_TcpIP(5) );

COPY_PORT_HTML_TO_FLASH_idx( TcpPort, 0 );
COPY_PORT_HTML_TO_FLASH_idx( TcpPort, 1 );
COPY_PORT_HTML_TO_FLASH_idx( TcpPort, 2 );
COPY_PORT_HTML_TO_FLASH_idx( TcpPort, 3 );
//    COPY_PORT_TO_FLASH( TcpPort[0], get_TcpPort(1) );
//    COPY_PORT_TO_FLASH( TcpPort[1], get_TcpPort(2) );
//    COPY_PORT_TO_FLASH( TcpPort[2], get_TcpPort(3) );
//    COPY_PORT_TO_FLASH( TcpPort[3], get_TcpPort(4) );

    strncpy( gps_rd->baud_rate, pch->get_selected_option( "baud_rate" ), 7 );
    strncpy( gps_rd->parity, pch->get_selected_option( "parity" ), 6 );
    strncpy( gps_rd->data_bits, pch->get_selected_option( "data_bits" ), 2 );
    strncpy( gps_rd->stop_bits, pch->get_selected_option( "stop_bits" ), 4 );
    
    fillDataIntoFlash( );
}


//#define COPY_IP_FLASH_TO_HTML( dest, source )   if( test_ip( gps_rd->source ) ) pch->dest( gps_rd->source );
#define COPY_IP_FLASH_TO_HTML( param )   if( test_ip( gps_rd->param ) ) pch->set_##param( gps_rd->param );
#define COPY_IP_FLASH_TO_HTML_idx( param, idx )   if( test_ip( gps_rd->param[idx] ) ) pch->set_##param( idx+1, gps_rd->param[idx] );

#define COPY_PORT_FLASH_TO_HTML( param ) if( test_num( gps_rd->param )) pch->set_##param(gps_rd->param);
#define COPY_PORT_FLASH_TO_HTML_idx( param, idx ) if( test_num( gps_rd->param[idx] )) pch->set_##param(idx+1, gps_rd->param[idx]);

void putFLASHintoHTML( C_HTMLparse *pch )
{
    
   refreshDataFromFlash( );
    
    COPY_IP_FLASH_TO_HTML( myIP );
    COPY_IP_FLASH_TO_HTML( myIP );
    COPY_IP_FLASH_TO_HTML( myMASK );
    COPY_IP_FLASH_TO_HTML( myGATE );
//    if( test_ip( gps_rd->myIP ) ) pch->set_myIP( gps_rd->myIP );
//    if( test_ip( gps_rd->myMASK ) ) pch->set_myMASK( gps_rd->myMASK );
//    if( test_ip( gps_rd->myGATE ) ) pch->set_myGATE( gps_rd->myGATE );

    COPY_PORT_FLASH_TO_HTML( myUdpPort );
    COPY_PORT_FLASH_TO_HTML( myTcpPort );
//    if( test_num( gps_rd->myUdpPort )) pch->set_myUdpPort(gps_rd->myUdpPort);
//    if( test_num( gps_rd->myTcpPort )) pch->set_myTcpPort(gps_rd->myTcpPort);
    
    COPY_IP_FLASH_TO_HTML_idx( UdpIP, 0 );
    COPY_IP_FLASH_TO_HTML_idx( UdpIP, 1 );
    COPY_IP_FLASH_TO_HTML_idx( UdpIP, 2 );
    COPY_IP_FLASH_TO_HTML_idx( UdpIP, 3 );
    COPY_IP_FLASH_TO_HTML_idx( UdpIP, 4 );
//    if( test_ip( gps_rd->UdpIP[0] ) ) pch->set_UdpIP(1,gps_rd->UdpIP[0]); 
//    if( test_ip( gps_rd->UdpIP[1] ) ) pch->set_UdpIP(2,gps_rd->UdpIP[1]); 
//    if( test_ip( gps_rd->UdpIP[2] ) ) pch->set_UdpIP(3,gps_rd->UdpIP[2]); 
//    if( test_ip( gps_rd->UdpIP[3] ) ) pch->set_UdpIP(4,gps_rd->UdpIP[3]); 
//    if( test_ip( gps_rd->UdpIP[4] ) ) pch->set_UdpIP(5,gps_rd->UdpIP[4]); 

    COPY_PORT_FLASH_TO_HTML_idx( UdpPort, 0 );
    COPY_PORT_FLASH_TO_HTML_idx( UdpPort, 1 );
    COPY_PORT_FLASH_TO_HTML_idx( UdpPort, 2 );
    COPY_PORT_FLASH_TO_HTML_idx( UdpPort, 3 );
//    if( test_num( gps_rd->UdpPort[0] ))   pch->set_UdpPort( 1, gps_rd->UdpPort[0] );
//    if( test_num( gps_rd->UdpPort[1] ))   pch->set_UdpPort( 2, gps_rd->UdpPort[1] );
//    if( test_num( gps_rd->UdpPort[2] ))   pch->set_UdpPort( 3, gps_rd->UdpPort[2] );
//    if( test_num( gps_rd->UdpPort[3] ))   pch->set_UdpPort( 4, gps_rd->UdpPort[3] );
     
    COPY_IP_FLASH_TO_HTML_idx( TcpIP, 0 );
    COPY_IP_FLASH_TO_HTML_idx( TcpIP, 1 );
    COPY_IP_FLASH_TO_HTML_idx( TcpIP, 2 );
    COPY_IP_FLASH_TO_HTML_idx( TcpIP, 3 );
    COPY_IP_FLASH_TO_HTML_idx( TcpIP, 4 );
 //   if( test_ip( gps_rd->TcpIP[0] ) ) pch->set_TcpIP(1, gps_rd->TcpIP[0]); 
//    if( test_ip( gps_rd->TcpIP[1] ) ) pch->set_TcpIP(2, gps_rd->TcpIP[1]); 
//    if( test_ip( gps_rd->TcpIP[2] ) ) pch->set_TcpIP(3, gps_rd->TcpIP[2]); 
//    if( test_ip( gps_rd->TcpIP[3] ) ) pch->set_TcpIP(4, gps_rd->TcpIP[3]); 
//    if( test_ip( gps_rd->TcpIP[4] ) ) pch->set_TcpIP(5, gps_rd->TcpIP[4]); 

    COPY_PORT_FLASH_TO_HTML_idx( TcpPort, 0 );
    COPY_PORT_FLASH_TO_HTML_idx( TcpPort, 1 );
    COPY_PORT_FLASH_TO_HTML_idx( TcpPort, 2 );
    COPY_PORT_FLASH_TO_HTML_idx( TcpPort, 3 );
//    if( test_num( gps_rd->TcpPort[0] ))  pch->set_TcpPort( 1, gps_rd->TcpPort[0] ); 
//    if( test_num( gps_rd->TcpPort[1] ))  pch->set_TcpPort( 2, gps_rd->TcpPort[1] ); 
//    if( test_num( gps_rd->TcpPort[2] ))  pch->set_TcpPort( 3, gps_rd->TcpPort[2] ); 
//    if( test_num( gps_rd->TcpPort[3] ))  pch->set_TcpPort( 4, gps_rd->TcpPort[3] ); 


    pch->set_selected_option( "baud_rate", gps_rd->baud_rate );
    pch->set_selected_option( "parity", gps_rd->parity );
    pch->set_selected_option( "data_bits", gps_rd->data_bits );
    pch->set_selected_option( "stop_bits", gps_rd->stop_bits );

}


