#include "mbed.h"
#include "clubbing.h"
#include "string.h"
#include "dxml.h"

#include "doHTML.h"
#include "dataFlash.h"
#include "HTMLpage.h"



/**************************  Pocetak *********************/

void test_HTML(void)
{
extern C_HTMLparse *gpc_html;

 P_str( "selected bit rate" ,  (char*)gpc_html->get_selected_option( "baud_rate" ) );
 P_str( "selected parity" ,  (char*)gpc_html->get_selected_option( "parity" ) );
 P_str( "selected stop bits" ,  (char*)gpc_html->get_selected_option( "stop_bits" ) );
 P_str( "selected data bits" ,  (char*)gpc_html->get_selected_option( "data_bits" ) );

    {
        extern UARTSerial *gp_scom;
        extern void sendScom( struct UARTSerial *p_scom, char *buffer, int val);

            auto c = gpc_html->getHTML_free( );
        //  n = p_soc->send(c, strlen(c));
            sendScom( gp_scom, c, strlen(c));
            free(c);
    }


 P_str( "select bit rate 38400", gpc_html->set_selected_option( "baud_rate", "38400" ) );
 P_str( "select bit parity ODD", gpc_html->set_selected_option( "parity", "odd" ) );
 P_str( "select stop bits 1.5", gpc_html->set_selected_option( "stop_bits", "1.5" ) );
 P_str( "select data bits 7", gpc_html->set_selected_option( "data_bits", "7" ) );

    {
        extern UARTSerial *gp_scom;
        extern void sendScom( struct UARTSerial *p_scom, char *buffer, int val);

            auto c = gpc_html->getHTML_free( );
        //  n = p_soc->send(c, strlen(c));
            sendScom( gp_scom, c, strlen(c));
            free(c);
    }


P_str( "selected bit rate" ,  (char*)gpc_html->get_selected_option( "baud_rate" ) );
 P_str( "selected parity" ,  (char*)gpc_html->get_selected_option( "parity" ) );
 P_str( "selected stop bits" ,  (char*)gpc_html->get_selected_option( "stop_bits" ) );
 P_str( "selected data bits" ,  (char*)gpc_html->get_selected_option( "data_bits" ) );

}
 
 



/************************ definicija klase C_HTMLparse ********************/

  void C_HTMLparse::load_front_row(void )
    {
        int i = 0;
        for (auto td = dxml_child(tr, "td")/*, i = 0*/; td; td = td->next)
        {
            auto input = dxml_child(td, "input");
            front_row[i] = input;
            ++i;
        }
        
        tr = tr->next;
    }
     
    void C_HTMLparse::load_second_row()
    {
        int i = 0;
        for (auto td = dxml_child(tr, "td")/*, i = 0*/; td; td = td->next)
        {
            auto input = dxml_child(td, "input");
            if (i == 0)
                UDPs[0] = input;
            else if(i == 1)
                TCPs[0] = input;
            ++i;
        }
        
        tr = tr->next;
    }
     
    void C_HTMLparse::load_udp_and_tcp(dxml_t& td)
    {
        for (int i = 0; i < 4; td = td->next)
        {
            dxml_t inputs[5];
            int input_count = 0;
            for (auto input = dxml_child(td, "input"); input; input = input->next)
                inputs[input_count++] = input;
            
            if (i < 2) // Load inputs into UDPs
            {
                for (int k = 0; k < input_count; ++k)
                    UDPs[i == 0 ? k + 1 : k + 6] = inputs[k];
            }
            else
            {
                for (int k = 0; k < input_count; ++k)
                    TCPs[i == 2 ? k + 1 : k + 6] = inputs[k];
            }
                    
            ++i;    
        }
    }
     
    void C_HTMLparse::load_serial(dxml_t& td)
    {
        auto select = dxml_child(td, "select");
        for (int i = 0; select; select = select->next)
            serial[i++] = select;
    }
     
 
    dxml_t C_HTMLparse::get_serial_option(dxml_t s, int option_idx)
    {
        auto rv = dxml_child(s, "option");
        for (int i = 0; i < option_idx; ++i)
        {
            if( rv->next == NULL ) return NULL;
            else rv = rv->next;
        }
        return rv;
    }

    C_HTMLparse::C_HTMLparse( void )
    {
        
        p_HTMLpage = (char*)malloc(strlen(HTMLpage)+1);
        strcpy( p_HTMLpage, HTMLpage);
        P_int("ucitavam html", strlen(HTMLpage));
        p_rootHTML = dxml_parse_str(p_HTMLpage, strlen(p_HTMLpage));
        intern_init( );
     }
     C_HTMLparse::C_HTMLparse( const char *str )
     {
        p_HTMLpage = (char*)malloc(strlen(str)+1);
        strcpy( p_HTMLpage, str);
        P_int("ucitavam html", strlen(str));
        p_rootHTML = dxml_parse_str(p_HTMLpage, strlen(p_HTMLpage));
        intern_init( );
         
     }
    
     
     void C_HTMLparse::intern_init( void )
     {   
        html_body = dxml_child(p_rootHTML, "body");
        html_form = dxml_child(html_body, "form");
        html_table = dxml_child(html_form, "table");
        tr = dxml_child(html_table, "tr");
        
        load_front_row();
        
        load_second_row();
        
        auto td = dxml_child(tr, "td");
        load_udp_and_tcp(td);
        load_serial(td);    
    }


    char *C_HTMLparse::getHTML_free( void )
    {
        return dxml_toxml(p_rootHTML);
    }


/****************** geteri - seteri *************************/




    const char * C_HTMLparse::get_selected_option( const char *name_option )
    {
        for( int i=0; dxml_attr(serial[i], "name") != NULL; i++ )
        {
           char *ret;  
             if( !strcmp( (char*)dxml_attr(serial[i], "name"), name_option) )
             {
               for(int j=0; dxml_attr(get_serial_option(serial[i], j), "value") != NULL; j++)
               {
                  if( dxml_attr( get_serial_option(serial[i],j), "selected" ) ) 
                    return  dxml_attr(get_serial_option(serial[i], j), "value");
                } 
               return  dxml_attr(get_serial_option(serial[i], 0), "value"); 
             }
        } 
        return NULL;
    }
    
    const char * C_HTMLparse::set_selected_option( const char* name_option, const char* value_option )
    {
        for( int i=0; dxml_attr(serial[i], "name") != NULL; i++ )
        {
        //   printf(" i = %d  \n\r", i );
           char *ret;  
             if( !strcmp( (char*)dxml_attr(serial[i], "name"), name_option) )
             {
               for(int j=0; dxml_attr(get_serial_option(serial[i], j), "value") != NULL; j++)
               {
          //        printf("  j=%d \n\r", j);
                  if( !strcmp( dxml_attr( get_serial_option(serial[i],j), "value"), value_option) )
                  {
                    if( !dxml_attr( get_serial_option(serial[i],j), "selected") )
                    { 
                        for(int k=0; dxml_attr(get_serial_option(serial[i], k), "value") != NULL; k++)
                        {
        //                  printf("   k=%d\n\r",k);
                          if( !strcmp( dxml_attr( get_serial_option(serial[i],k), "value"), value_option) )
                          { 
                             printf("   kk=%d\n\r",k); 
                             dxml_set_attr( get_serial_option(serial[i],k), "selected", "ON" );
                          }
                          else  
                          {  
                              printf("   k=%d\n\r",k); 
                              dxml_set_attr( get_serial_option(serial[i],k), "selected", NULL );
                          }
                        }
                    }
                    return value_option;
                  }
                }  
             }
        } 
        
        return NULL;
        
    }



    void C_HTMLparse::set_myIP( const char* str )
    {
       if( test_ip( str ) )  dxml_set_attr( front_row[0], "value", str);
    }
    void C_HTMLparse::set_myMASK( const char* str )
    {
       if( test_ip( str ) )  dxml_set_attr( front_row[1], "value", str);
    }
    void C_HTMLparse::set_myGATE( const char* str )
    {
       if( test_ip( str ) )  dxml_set_attr( front_row[2], "value", str);
    }

    void C_HTMLparse::set_myUdpPort( const char* str )
    {
        if( test_num( str ) ) dxml_set_attr( UDPs[0], "value", str );
    }
    void C_HTMLparse::set_myTcpPort( const char* str ) 
    {
         if( test_num( str) ) dxml_set_attr( TCPs[0], "value", str);
    }

    void C_HTMLparse::set_UdpIP( int i, const char* str )
    {
        if( (i > 0) && (i <= 5 ) && test_ip( str ) )      dxml_set_attr( UDPs[i], "value", str); 
    }    
    void C_HTMLparse::set_UdpPort( int i, const char* str )
    {
        if( (i>0) && (i<= 4) && test_num( str ) )     dxml_set_attr( UDPs[i+6], "value", str) ;
    }
    
    void C_HTMLparse::set_TcpIP( int i, const char* str )
    {
        if( (i > 0) && (i <= 5 ) && test_ip( str ) )      dxml_set_attr( TCPs[i], "value", str); 
    }    
    void C_HTMLparse::set_TcpPort( int i, const char* str )
    {
        if( (i>0) && (i<= 4) && test_num( str ) )     dxml_set_attr( TCPs[i+6], "value", str) ;
    }

    const char *C_HTMLparse::get_myIP( void )
    {
       return dxml_attr( front_row[0], "value");
    }
    const char *C_HTMLparse::get_myMASK(void)
    {
        return dxml_attr( front_row[1], "value");
    }
    const char *C_HTMLparse::get_myGATE( void )
    {
        return dxml_attr( front_row[2], "value");
    }

    const char *C_HTMLparse::get_myUdpPort( void )
    {
        return dxml_attr( UDPs[0], "value" );
    }
    const char *C_HTMLparse::get_myTcpPort( void ) 
    {
        return dxml_attr( TCPs[0], "value");
    }
    
    const char *C_HTMLparse::get_UdpIP( int i )
    {
        if( (i > 0) && (i <= 5 ) )        return dxml_attr( UDPs[i], "value"); 
        return NULL;
    }
    
    const char *C_HTMLparse::get_UdpPort( int i )
    {
        if( (i>0) && (i<= 4) )    return dxml_attr( UDPs[i+6], "value") ;
        return NULL; 
    }
    
    const char *C_HTMLparse::get_TcpIP( int i )
    {
        if( (i > 0) && (i <= 5 ) )        return dxml_attr( TCPs[i], "value"); 
        return NULL;
    }
    
    const char *C_HTMLparse::get_TcpPort( int i )
    {
        if( (i>0) && (i<= 4) )    return dxml_attr( TCPs[i+6], "value") ;
        return NULL; 
    }
 


